/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.metrics;

import com.manageengine.apminsight.agent.metrics.HTTPMetric;
import com.manageengine.apminsight.agent.util.JavaAgentUtil;
import com.manageengine.org.json.simple.JSONArray;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;

public final class ApdexMetric
extends HTTPMetric {
    protected int satisfied = 0;
    protected int tolerating = 0;
    protected int frustrated = 0;
    protected float apdex = 0.0f;

    public void recordData(int responseTime, float apdexThreshold) {
        super.recordData(responseTime);
        if ((float)responseTime <= apdexThreshold) {
            ++this.satisfied;
        } else if ((float)responseTime > 4.0f * apdexThreshold) {
            ++this.frustrated;
        } else {
            ++this.tolerating;
        }
    }

    public void recordData(ApdexMetric apdexMetric) {
        super.recordData(apdexMetric);
        this.satisfied += apdexMetric.satisfied;
        this.tolerating += apdexMetric.tolerating;
        this.frustrated += apdexMetric.frustrated;
    }

    public float getApdex() {
        return this.count == 0L ? 0.0f : ((float)this.satisfied + (float)this.tolerating / 2.0f) / (float)this.count;
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        JSONArray.writeJSONString(this.getDataInList(), out);
    }

    @Override
    protected List getDataInList() {
        Number[] n = new Number[]{this.responseTime, this.minRT == Long.MAX_VALUE ? 0L : Long.valueOf(this.minRT), this.maxRT, this.count, Float.valueOf(this.getApdex()), (long)this.satisfied, (long)this.tolerating, (long)this.frustrated, this.errorCount};
        ArrayList<Object> list = new ArrayList<Object>(5);
        list.add(Arrays.asList(n));
        LinkedHashMap<String, Object> sack = new LinkedHashMap<String, Object>();
        list.add(super.getComponentMetricDataInMap(sack));
        this.getLogCountDataInMap(sack);
        this.getHttpMetricDataInMap(sack);
        return list;
    }

    @Override
    public String toString() {
        return JavaAgentUtil.listToString(this.getDataInList());
    }
}

