/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.metrics;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.metrics.MetricData;
import com.manageengine.apminsight.agent.metrics.ResponseTimeMetric;
import com.manageengine.apminsight.agent.util.JavaAgentUtil;
import com.manageengine.org.json.simple.JSONArray;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AppParamMetric
implements MetricData {
    Map<String, Object> parameters = new HashMap<String, Object>();

    public void recordData(String key, Double value, String type) {
        if (this.parameters.size() < JavaAgent.getInstance().agentConfig.getMaxCustomMetricStoreSize()) {
            if (type.equals("sum")) {
                this.recordIncrementCounter(key, value);
            } else if (type.equals("average")) {
                this.recordAverage(key, value);
            }
        } else {
            JavaAgent.logger.debug("Dropping App param attribute: '" + key + "'. Custom metric store size limit reached. Current limit = " + JavaAgent.getInstance().agentConfig.getMaxCustomMetricStoreSize());
        }
    }

    private void recordIncrementCounter(String key, Double value) {
        try {
            Object oldValue = this.parameters.get(key);
            this.parameters.put(key, oldValue == null ? value : (Double)oldValue + value);
        }
        catch (Exception e) {
            JavaAgent.logger.warn("Error recording increment counter. Exception: " + e.getMessage());
        }
    }

    public int getMetricSize() {
        return this.parameters.size();
    }

    private void recordAverage(String key, Double value) {
        try {
            ResponseTimeMetric oldValue = (ResponseTimeMetric)this.parameters.get(key);
            if (oldValue == null) {
                oldValue = new ResponseTimeMetric();
                this.parameters.put(key, oldValue);
            }
            oldValue.recordData(value.longValue());
        }
        catch (Exception e) {
            JavaAgent.logger.warn("Error recording average App Parameter metric. Exception: " + e.getMessage());
        }
    }

    private List getDataInList() {
        ArrayList<List<Object>> data = new ArrayList<List<Object>>(1);
        data.add(Arrays.asList(this.parameters));
        return data;
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        JSONArray.writeJSONString(this.getDataInList(), out);
    }

    public String toString() {
        return JavaAgentUtil.listToString(this.getDataInList());
    }
}

