/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.metrics;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.components.Component;
import com.manageengine.apminsight.agent.metrics.LogCountMetric;
import com.manageengine.apminsight.agent.util.InetAddressUtil;
import com.manageengine.apminsight.agent.util.JavaAgentUtil;
import com.manageengine.apminsight.agent.util.StringUtils;
import com.manageengine.org.json.simple.JSONArray;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ComponentMetric
extends LogCountMetric {
    private static final byte COUNT_INDEX = 0;
    private static final byte TIME_INDEX = 1;
    private static final byte ERROR_INDEX = 2;
    protected Map<ComponentInfo, Integer[]> componentData = new HashMap<ComponentInfo, Integer[]>();
    protected int threadCpuTime = 0;

    public ComponentInfo recordComponentData(Component component, int time, boolean isErroneous) {
        return this.recordComponentData(component, null, time, isErroneous);
    }

    public ComponentInfo recordComponentData(Component component, String address, String instanceId, int time, boolean isErroneous) {
        ComponentInfo cInfo = this.recordComponentData(component, address, time, isErroneous);
        cInfo.instanceId = instanceId;
        return cInfo;
    }

    public ComponentInfo recordComponentData(Component component, String address, int time, boolean isErroneous) {
        ComponentInfo c = new ComponentInfo(component, address);
        Integer[] value = this.componentData.get(c);
        if (value == null) {
            value = new Integer[3];
            value[1] = value[2] = Integer.valueOf(0);
            value[0] = value[2];
            if (this.componentData.size() < JavaAgent.getInstance().agentConfig.getComponentsPerTxnLimit()) {
                this.componentData.put(c, value);
            }
        }
        Integer[] integerArray = value;
        int n = 0;
        Integer n2 = integerArray[n];
        Integer n3 = integerArray[n] = Integer.valueOf(integerArray[n] + 1);
        integerArray = value;
        n = 1;
        Integer.valueOf(integerArray[n] + time);
        if (isErroneous) {
            integerArray = value;
            n = 2;
            n2 = integerArray[n];
            n3 = integerArray[n] = Integer.valueOf(integerArray[n] + 1);
        }
        return c;
    }

    public void recordThreadCpuTime(int cpuTimeInMilliSec) {
        this.threadCpuTime += cpuTimeInMilliSec;
    }

    public void recordComponentData(ComponentMetric componentMetric) {
        if (componentMetric != null) {
            for (Map.Entry<ComponentInfo, Integer[]> entry : componentMetric.componentData.entrySet()) {
                Integer[] value = this.componentData.get(entry.getKey());
                if (value == null) {
                    value = new Integer[3];
                    value[1] = value[2] = Integer.valueOf(0);
                    value[0] = value[2];
                    this.componentData.put(entry.getKey(), value);
                }
                Integer[] integerArray = value;
                int n = 0;
                Integer.valueOf(integerArray[n] + entry.getValue()[0]);
                integerArray = value;
                n = 1;
                Integer.valueOf(integerArray[n] + entry.getValue()[1]);
                integerArray = value;
                n = 2;
                Integer.valueOf(integerArray[n] + entry.getValue()[2]);
            }
        }
        this.recordThreadCpuTime(componentMetric.threadCpuTime);
    }

    protected Map<String, Object> getComponentMetricDataInMap(Map<String, Object> sack) {
        ArrayList componentMetricData = new ArrayList();
        for (Map.Entry<ComponentInfo, Integer[]> entry : this.componentData.entrySet()) {
            LinkedHashMap<String, Object> componentData = new LinkedHashMap<String, Object>();
            Component component = entry.getKey().component;
            String componentAddr = entry.getKey().address;
            componentData.put("name", component.toString());
            componentData.put("rt", entry.getValue()[1]);
            componentData.put("ct", entry.getValue()[0]);
            componentData.put("error", entry.getValue()[2]);
            componentData.put("isExt", component.isExternal() ? 1 : 0);
            if (!StringUtils.isEmptyString(componentAddr)) {
                componentData.put("ip", InetAddressUtil.getIPAddress(componentAddr));
                componentData.put("host", InetAddressUtil.getHostName(componentAddr));
                componentData.put("port", InetAddressUtil.getPort(componentAddr));
                if (entry.getKey().instanceId != null) {
                    componentData.put("instance_id", entry.getKey().instanceId);
                }
            }
            componentMetricData.add(componentData);
        }
        sack.put("components", componentMetricData);
        sack.put("cputime", this.threadCpuTime);
        sack.put("error_rt", this.error_rt);
        return sack;
    }

    @Override
    protected List getDataInList() {
        Number[] n = new Number[]{this.responseTime, this.minRT == Long.MAX_VALUE ? 0L : Long.valueOf(this.minRT), this.maxRT, this.count, this.errorCount};
        ArrayList<Object> list = new ArrayList<Object>(5);
        list.add(Arrays.asList(n));
        LinkedHashMap<String, Object> sack = new LinkedHashMap<String, Object>();
        list.add(this.getComponentMetricDataInMap(sack));
        this.getLogCountDataInMap(sack);
        return list;
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        JSONArray.writeJSONString(this.getDataInList(), out);
    }

    @Override
    public String toString() {
        return JavaAgentUtil.listToString(this.getDataInList());
    }

    static class ComponentInfo {
        private Component component;
        private String address;
        private String instanceId;

        ComponentInfo(Component component, String address) {
            this.component = component;
            this.address = StringUtils.isEmptyString(address) ? "" : address;
        }

        public boolean equals(Object o) {
            ComponentInfo cInfo = (ComponentInfo)o;
            return this.component == cInfo.component && this.address.equals(cInfo.address);
        }

        public int hashCode() {
            return this.component.hashCode() ^ this.address.hashCode();
        }
    }
}

