/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.metrics;

import com.manageengine.apminsight.agent.metrics.ExceptionMetric;
import com.manageengine.apminsight.agent.tracing.exception.ErrorThrowable;
import java.util.Map;

public class LogCountMetric
extends ExceptionMetric {
    private int fatalLogCount = 0;
    private int warningLogCount = 0;

    public void recordLogCountData(boolean isFatal, ErrorThrowable throwable) {
        if (isFatal) {
            ++this.fatalLogCount;
        } else {
            ++this.warningLogCount;
        }
        this.exceptions.add(throwable);
    }

    public void recordLogCountData(LogCountMetric logCountMetric) {
        this.fatalLogCount += logCountMetric.fatalLogCount;
        this.warningLogCount += logCountMetric.warningLogCount;
        this.exceptions.addAll(logCountMetric.exceptions);
    }

    public Map<String, Object> getLogCountDataInMap(Map<String, Object> sack) {
        Map<String, Integer> metricData = this.getExceptionMetricDataInMap();
        metricData.put("warning", this.warningLogCount);
        metricData.put("fatal", this.fatalLogCount);
        sack.put("logmetric", metricData);
        return sack;
    }
}

