/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.metrics;

import com.manageengine.apminsight.agent.metrics.MetricData;
import com.manageengine.apminsight.agent.util.JavaAgentUtil;
import com.manageengine.org.json.simple.JSONArray;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class ResponseTimeMetric
implements MetricData {
    protected String contextName = "";
    protected long responseTime = 0L;
    protected long minRT = Long.MAX_VALUE;
    protected long maxRT = 0L;
    protected long count;
    public AtomicInteger actualCount = new AtomicInteger(0);
    protected long errorCount;
    protected long error_rt = 0L;

    public void recordData(long responseTime) {
        if (responseTime > -1L) {
            this.minRT = Math.min(responseTime, this.minRT);
            this.maxRT = Math.max(responseTime, this.maxRT);
            this.responseTime += responseTime;
        }
        ++this.count;
    }

    public void recordData(int responseTime) {
        this.recordData((long)responseTime);
    }

    public void recordErroneousData(int responseTime) {
        this.error_rt += (long)responseTime;
        ++this.errorCount;
    }

    public void recordData(ResponseTimeMetric rtMetric) {
        this.responseTime += rtMetric.responseTime;
        this.count += rtMetric.count;
        this.errorCount += rtMetric.errorCount;
        this.error_rt += rtMetric.error_rt;
        this.minRT = Math.min(this.minRT, rtMetric.minRT);
        this.maxRT = Math.max(this.maxRT, rtMetric.maxRT);
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public String getContextName() {
        return this.contextName;
    }

    protected List getDataInList() {
        return Arrays.asList(this.responseTime, this.minRT == Long.MAX_VALUE ? 0L : Long.valueOf(this.minRT), this.maxRT, this.count, this.errorCount);
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        JSONArray.writeJSONString(this.getDataInList(), out);
    }

    public String toString() {
        return JavaAgentUtil.listToString(this.getDataInList());
    }
}

