/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.metrics.store;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.metric.MetricConstants;
import com.manageengine.apminsight.agent.metrics.GlobalMetrics;
import com.manageengine.apminsight.agent.metrics.Metric;
import com.manageengine.apminsight.agent.metrics.MetricName;
import com.manageengine.apminsight.agent.metrics.MetricType;
import com.manageengine.apminsight.agent.metrics.store.MetricStore;
import com.manageengine.org.apache.logging.log4j.Level;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractMetricStore
implements MetricStore,
MetricConstants {
    protected Map<MetricName, Metric> metricBucket = new HashMap<MetricName, Metric>();
    protected Map<String, Metric> apdexMetricBucket = new HashMap<String, Metric>();
    protected Map<String, Metric> backgroundMetricBucket = new HashMap<String, Metric>();
    protected Map<String, Metric> jvmMetricBucket = new HashMap<String, Metric>();
    protected Map<String, Metric> appParamsBucket = new HashMap<String, Metric>();
    public static final MetricName OVERFLOW_METRICNAME = new MetricName("", "0verf10w", "db/0verf10w//");
    public static final Metric METRICBUCKET_OVERFLOW_INFORMER = new Metric(OVERFLOW_METRICNAME, MetricType.RESPONSETIME);

    @Override
    public abstract String getName();

    @Override
    public Metric getMetric(String nameSpace, String name, MetricType type, boolean forceCreate) {
        return this.getMetric(new MetricName("", nameSpace, name), type, forceCreate);
    }

    @Override
    public Metric getMetric(String context, String nameSpace, String name, MetricType type, boolean forceCreate) {
        return this.getMetric(new MetricName(context, nameSpace, name), type, forceCreate);
    }

    @Override
    public Metric getMetric(Metric metric, boolean forceCreate) {
        return this.getMetric(metric.getMetricName(), metric.getMetricType(), forceCreate);
    }

    @Override
    public Metric getMetric(MetricName metricName, MetricType type, boolean forceCreate) {
        Metric metric = null;
        metric = MetricType.APDEX.equals((Object)type) ? this.apdexMetricBucket.get(metricName.getNameSpace()) : (MetricType.BACKGROUND.equals((Object)type) ? this.backgroundMetricBucket.get(metricName.getNameSpace()) : (MetricType.APP_PARAMS == type ? this.appParamsBucket.get(metricName.toString()) : (MetricType.JVM == type ? this.jvmMetricBucket.get(metricName.getName()) : this.metricBucket.get(metricName))));
        if (metric == null) {
            metric = this.constructMetric(metricName, type, forceCreate);
        }
        return metric;
    }

    protected synchronized Metric constructMetric(MetricName metricName, MetricType type, boolean forceCreate) {
        if (MetricType.APDEX.equals((Object)type)) {
            Metric apdexMetric = this.apdexMetricBucket.get(metricName.getNameSpace());
            if (apdexMetric == null) {
                return this.createApdexMetric(metricName, forceCreate);
            }
            JavaAgent.logger.log(Level.INFO, "ApdexMetric {} duplicate creation avoided.", (Object)metricName);
            return apdexMetric;
        }
        if (MetricType.BACKGROUND.equals((Object)type)) {
            Metric backgroundMetric = this.backgroundMetricBucket.get(metricName.getNameSpace());
            if (backgroundMetric == null) {
                return this.createBackgroundMetric(metricName, forceCreate);
            }
            return backgroundMetric;
        }
        if (MetricType.APP_PARAMS == type) {
            Metric metric = this.appParamsBucket.get(metricName.toString());
            return metric == null ? this.createAppParamMetric(metricName, type) : metric;
        }
        if (MetricType.JVM == type) {
            Metric jvmMetric = this.jvmMetricBucket.get(metricName.getName());
            if (jvmMetric == null) {
                return this.createJvmMetric(metricName, type);
            }
            return jvmMetric;
        }
        Metric metric = this.metricBucket.get(metricName);
        if (metric == null) {
            return this.createMetric(metricName, type);
        }
        JavaAgent.logger.log(Level.INFO, "Metric {} duplicate creation avoided.", (Object)metricName);
        return metric;
    }

    protected Metric createJvmMetric(MetricName metricName, MetricType type) {
        Metric newJvmMetric = GlobalMetrics.I_JVM;
        this.jvmMetricBucket.put(metricName.getName(), newJvmMetric);
        return newJvmMetric;
    }

    protected Metric createAppParamMetric(MetricName metricName, MetricType type) {
        Metric metric = new Metric(metricName, type);
        this.appParamsBucket.put(metricName.toString(), metric);
        return metric;
    }

    protected Metric createMetric(MetricName metricName, MetricType type) {
        int threshold;
        Metric newMetric = new Metric(metricName, type);
        int size = this.metricBucket.size();
        if (size == (threshold = JavaAgent.getInstance().agentConfig.getMaxDBMetricStoreSize())) {
            this.metricBucket.put(OVERFLOW_METRICNAME, METRICBUCKET_OVERFLOW_INFORMER);
            JavaAgent.logger.warn("DBMetricBucket overflow. CurrentSize is :" + size);
        } else if (size < threshold) {
            this.metricBucket.put(metricName, newMetric);
        }
        return newMetric;
    }

    protected Metric createApdexMetric(MetricName metricName, boolean forceCreate) {
        int threshold;
        Metric newApdexMetric = new Metric(metricName, MetricType.APDEX);
        if (forceCreate) {
            this.apdexMetricBucket.put(metricName.getNameSpace(), newApdexMetric);
            return newApdexMetric;
        }
        int size = this.apdexMetricBucket.size();
        if (size < (threshold = JavaAgent.getInstance().agentConfig.getMaxWebMetricStoreSize())) {
            this.apdexMetricBucket.put(metricName.getNameSpace(), newApdexMetric);
        } else {
            JavaAgent.logger.warn("ApdexMetricBucket overflow. CurrentSize is :" + size);
        }
        return newApdexMetric;
    }

    protected Metric createBackgroundMetric(MetricName metricName, boolean forceCreate) {
        int threshold;
        Metric newM = new Metric(metricName, MetricType.BACKGROUND);
        if (forceCreate) {
            this.backgroundMetricBucket.put(metricName.getNameSpace(), newM);
            return newM;
        }
        int size = this.backgroundMetricBucket.size();
        if (size < (threshold = JavaAgent.getInstance().agentConfig.getMaxBackgroundMetricStoreSize())) {
            this.backgroundMetricBucket.put(metricName.getNameSpace(), newM);
        } else {
            JavaAgent.logger.warn("BackgroundMetricBucket overflow. CurrentSize is :" + size);
        }
        return newM;
    }

    @Override
    public List<Metric> getAllMetrics() {
        JavaAgent.logger.trace("[AbstractMetricStore] MetricBucket: " + this.metricBucket);
        JavaAgent.logger.trace("[AbstractMetricStore] ApdexMetricBucket: " + this.apdexMetricBucket);
        JavaAgent.logger.trace("[AbstractMetricStore] JvmMetricBucket: " + this.jvmMetricBucket);
        ArrayList<Metric> allMetrics = new ArrayList<Metric>(this.metricBucket.size() + this.apdexMetricBucket.size() + this.jvmMetricBucket.size());
        allMetrics.addAll(this.apdexMetricBucket.values());
        allMetrics.addAll(this.backgroundMetricBucket.values());
        allMetrics.addAll(this.metricBucket.values());
        allMetrics.addAll(this.jvmMetricBucket.values());
        allMetrics.addAll(this.appParamsBucket.values());
        return allMetrics;
    }

    public List<Metric> getJvmMetrics() {
        ArrayList<Metric> metrics = new ArrayList<Metric>(this.jvmMetricBucket.size());
        metrics.addAll(this.jvmMetricBucket.values());
        return metrics;
    }

    public List<Metric> getMetrics() {
        ArrayList<Metric> metrics = new ArrayList<Metric>(this.metricBucket.size());
        metrics.addAll(this.metricBucket.values());
        return metrics;
    }

    public List<Metric> getApdexMetrics() {
        ArrayList<Metric> allApdexMetrics = new ArrayList<Metric>(this.apdexMetricBucket.size());
        allApdexMetrics.addAll(this.apdexMetricBucket.values());
        return allApdexMetrics;
    }

    public List<Metric> getBackgroundMetrics() {
        ArrayList<Metric> allBackgroudMetrics = new ArrayList<Metric>(this.backgroundMetricBucket.size());
        allBackgroudMetrics.addAll(this.backgroundMetricBucket.values());
        return allBackgroudMetrics;
    }

    @Override
    public void cleanMetricStore() {
        this.apdexMetricBucket.clear();
        this.backgroundMetricBucket.clear();
        this.metricBucket.clear();
        this.jvmMetricBucket.clear();
        this.appParamsBucket.clear();
        JavaAgent.logger.log(Level.DEBUG, "MetricStore {} is cleaned.", (Object)this.getName());
    }

    @Override
    public int[] getOccupiedSize() {
        int[] size = new int[]{this.apdexMetricBucket.size(), this.metricBucket.size(), this.jvmMetricBucket.size(), this.appParamsBucket.size()};
        return size;
    }

    public Metric removeApdexMetric(String namespace) {
        return this.apdexMetricBucket.remove(namespace);
    }

    public Metric removeBackgroundMetric(String namespace) {
        return this.backgroundMetricBucket.remove(namespace);
    }

    @Override
    public Metric findApdexMetric(String nameSpace) {
        return this.apdexMetricBucket.get(nameSpace);
    }

    @Override
    public Metric findBackgroundMetric(String nameSpace) {
        return this.backgroundMetricBucket.get(nameSpace);
    }
}

