/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.metrics.store;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.context.ContextInfo;
import com.manageengine.apminsight.agent.context.ContextInfoManager;
import com.manageengine.org.apache.hc.client5.http.entity.EntityBuilder;
import com.manageengine.org.apache.hc.core5.http.ContentType;
import com.manageengine.org.apache.hc.core5.http.HttpEntity;
import com.manageengine.org.json.simple.JSONValue;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.zip.GZIPInputStream;

public class DataCacher
implements Runnable {
    private static DataCacher dataCacher = new DataCacher();
    private boolean isDispatchThreadRunning = false;
    private boolean stopFlag;

    @Override
    public void run() {
        JavaAgent.logger.info(Thread.currentThread().getName() + " started.");
        this.stopFlag = false;
        while (!this.stopFlag) {
            try {
                this.isDispatchThreadRunning = true;
                this.dispatchFileData();
            }
            catch (Throwable th) {
                JavaAgent.logger.warn("Exception while dispatching files : " + th.getMessage());
            }
        }
        this.isDispatchThreadRunning = false;
        JavaAgent.logger.info(Thread.currentThread().getName() + " ended.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDatatoFile(ContextInfo contextInfo, String operation, Object data, HttpEntity entity) {
        ByteArrayOutputStream baos = null;
        OutputStream os = null;
        try {
            if (entity == null && data != null) {
                StringWriter out = new StringWriter();
                JSONValue.writeJSONString(data, out);
                EntityBuilder entityBuilder = EntityBuilder.create().setText(((Object)out).toString()).setContentType(ContentType.APPLICATION_JSON);
                entity = entityBuilder.gzipCompressed().build();
                baos = new ByteArrayOutputStream();
                entity.writeTo(baos);
                File dataDir = new File(contextInfo.getContextLocation() + File.separator + "data");
                if (!dataDir.exists()) {
                    dataDir.mkdirs();
                }
                File dataFile = new File(dataDir, System.currentTimeMillis() + "_" + operation + ".txt");
                os = new FileOutputStream(dataFile);
                baos.writeTo(os);
                JavaAgent.logger.info("[DataCacher] " + operation.toUpperCase() + " written to file " + dataFile.getAbsolutePath());
                dataDir = null;
                dataFile = null;
                JavaAgent.getInstance().getAgentService().cachedDataExists = true;
                this.clearCachedFilesAfterRetentionTime();
            }
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("[DataCacher] Exception occured when writing " + operation + " to file.\n");
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException out) {}
        }
    }

    private void clearCachedFilesAfterRetentionTime() {
        int deletecount = 0;
        long thresholdMillis = JavaAgent.getInstance().getAgentConfig().getDataRetentionThreshold();
        for (ContextInfo contextInfo : ContextInfoManager.getInstance().getAllContexts()) {
            File[] cachedFiles = this.getListofCachedFiles(new File(contextInfo.getContextLocation() + File.separator + "data"));
            long currentTimeMillis = System.currentTimeMillis();
            for (File cFile : cachedFiles) {
                try {
                    long fileTime = Long.parseLong(cFile.getName().split("_")[0]);
                    if (currentTimeMillis - fileTime <= thresholdMillis) continue;
                    cFile.delete();
                    ++deletecount;
                }
                catch (Throwable th) {
                    JavaAgent.logger.warn("[DataCacher] Exception while deleting threshold exceeded file. Will retry in next attempt.");
                }
            }
        }
        JavaAgent.logger.debug("[DataCacher] " + deletecount + " cached files have been deleted after being retained for > " + thresholdMillis * 60L * 60L * 1000L + " hours.");
    }

    public void dispatchFileData() throws Exception {
        int dispatchcount = 0;
        int tobeDispatchedCount = 0;
        for (ContextInfo contextInfo : ContextInfoManager.getInstance().getAllContexts()) {
            File dataDir = new File(contextInfo.getContextLocation() + File.separator + "data");
            if (!dataDir.exists()) continue;
            File[] cachedFiles = this.getListofCachedFiles(new File(dataDir.getAbsolutePath()));
            tobeDispatchedCount += cachedFiles.length;
            for (File cFile : cachedFiles) {
                String operation = cFile.getName().endsWith("data.txt") ? "data" : "trace";
                String out = this.readDatafromFile(cFile);
                boolean isSendSuccess = false;
                try {
                    if (!out.isEmpty()) {
                        JavaAgent.getInstance().getAgentService().sendCachedDataToServer(contextInfo, operation, out);
                        isSendSuccess = true;
                    }
                }
                catch (Throwable th) {
                    JavaAgent.logger.warn("Error in sending cached " + operation + " to server from file " + cFile + ". Exception :" + th.getMessage());
                }
                if (!isSendSuccess) continue;
                ++dispatchcount;
                cFile.delete();
            }
            JavaAgent.logger.info("[DataCacher] " + dispatchcount + " cached files have been dispatched and deleted for the context - " + contextInfo.getContextName());
        }
        if (tobeDispatchedCount - dispatchcount == 0) {
            JavaAgent.getInstance().getAgentService().cachedDataExists = false;
        }
        this.stopFlag = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readDatafromFile(File dataFile) {
        String content = "";
        ByteArrayOutputStream baos = null;
        GZIPInputStream gis = null;
        try {
            int bytesRead;
            gis = new GZIPInputStream(new FileInputStream(dataFile));
            baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((bytesRead = gis.read(buffer)) != -1) {
                baos.write(buffer, 0, bytesRead);
            }
            byte[] fullContent = baos.toByteArray();
            content = new String(fullContent);
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("[DataCacher] Unable to read content from file : " + dataFile.getAbsolutePath() + " - " + th.getMessage());
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
                if (gis != null) {
                    gis.close();
                }
            }
            catch (IOException buffer) {}
        }
        return content;
    }

    private File[] getListofCachedFiles(File dataDir) {
        File[] dataFiles = dataDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File fileDir, String fileName) {
                return fileName.endsWith("data.txt") || fileName.endsWith("trace.txt");
            }
        });
        return dataFiles;
    }

    public boolean isDispatchThreadRunning() {
        return this.isDispatchThreadRunning;
    }

    public static DataCacher getInstance() {
        return dataCacher;
    }
}

