/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.ondemand;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.logging.AgentLogger;
import com.manageengine.apminsight.agent.ondemand.OnDemandTask;
import com.manageengine.apminsight.agent.thread.WorkerThreadFactory;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ArrayBlockingQueue;

public class OnDemandTasksHandler
implements Runnable {
    private static final String TASK_THREAD_NAME_PREFIX = "apminsight-on_demand-";
    private static ArrayBlockingQueue<OnDemandTask> heavyTasksQueue = new ArrayBlockingQueue(5);
    private AgentLogger logger = JavaAgent.logger;
    private static Set<OnDemandTask> allRunningTaskList = Collections.newSetFromMap(new WeakHashMap());

    public static boolean addTask(OnDemandTask task) {
        try {
            boolean isAlreadyRunning = allRunningTaskList.stream().anyMatch(t -> t.getTaskName().equals(task.getTaskName()));
            boolean isAlreadyQueued = heavyTasksQueue.stream().anyMatch(t -> t.getTaskName().equals(task.getTaskName()));
            if (isAlreadyRunning || isAlreadyQueued) {
                JavaAgent.logger.warn("{} task is already running/queued.", task.getTaskName());
                return false;
            }
            if (task.getWeightage() == OnDemandTask.TaskWeightage.LITE) {
                return OnDemandTasksHandler.startTask(task) != null;
            }
            return heavyTasksQueue.add(task);
        }
        catch (NullPointerException e) {
            JavaAgent.logger.warn("null Task cannot be added to queue.");
        }
        catch (IllegalStateException e) {
            JavaAgent.logger.warn("On-Demand Tasks Queue is full, current queue size: " + heavyTasksQueue.size());
        }
        return false;
    }

    @Override
    public void run() {
        this.logger.info("On-Demand tasks handler is running & awating for on-demand tasks");
        boolean isInterrupted = false;
        while (!isInterrupted) {
            try {
                OnDemandTask task = heavyTasksQueue.take();
                Thread thread = OnDemandTasksHandler.startTask(task);
                if (thread != null) {
                    thread.join();
                }
                this.logger.info("{} has completed/interrupted. Pending tasks count: {}", task.getTaskName(), heavyTasksQueue.size());
            }
            catch (InterruptedException e) {
                this.logger.warn("On-Demand Tasks handler interrupted, Quitting.");
                isInterrupted = true;
            }
        }
        this.logger.info("On-Demand Tasks Handler stopped.");
    }

    private static Thread startTask(OnDemandTask task) {
        try {
            String taskName = task.getTaskName();
            Thread thread = WorkerThreadFactory.getInstance().newThread(task);
            thread.setName(TASK_THREAD_NAME_PREFIX + taskName);
            thread.start();
            allRunningTaskList.add(task);
            JavaAgent.logger.info("[OnDemandTasksHandler] {} has started", taskName);
            return thread;
        }
        catch (Throwable th) {
            return null;
        }
    }

    public static void notifyCompleted(OnDemandTask onDemandTask) {
        allRunningTaskList.remove(onDemandTask);
    }

    public static boolean shutdown() {
        boolean isAllTasksStopped = true;
        for (OnDemandTask task : allRunningTaskList) {
            isAllTasksStopped &= task.stop();
        }
        return isAllTasksStopped;
    }

    public static String getOnDemandTaskStats() {
        StringBuilder sb = new StringBuilder("On-Demand-Tasks-Stats:");
        sb.append("\tCurrent Running tasks: " + allRunningTaskList.size());
        sb.append("\tCurrent Queued tasks: " + heavyTasksQueue.size());
        sb.append("\tRunning: " + allRunningTaskList.toString());
        sb.append("\tQueued: " + heavyTasksQueue.toString());
        return sb.toString();
    }
}

