/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.sequence;

import com.manageengine.apminsight.agent.JavaAgent;
import java.util.Map;
import java.util.WeakHashMap;

public class HandHoldingSpace {
    public static final ThreadLocal<HandHoldingSpace> SPACE = new ThreadLocal<HandHoldingSpace>(){

        @Override
        protected HandHoldingSpace initialValue() {
            return new HandHoldingSpace();
        }
    };
    private Map<Object, Object> idHolder = new WeakHashMap<Object, Object>();
    private Map<Object, Object> untilConsumed = new WeakHashMap<Object, Object>();
    private static final int MAX_SIZE = 5;

    private HandHoldingSpace() {
    }

    public void storeWithID(Object id, Object obj) {
        this.idHolder.put(id, obj);
    }

    public void storeUntilConsumed(Object id, Object obj) {
        if (this.untilConsumed.size() == 5) {
            JavaAgent.logger.debug("Handholding space exhausted, clearing values: " + this.untilConsumed.keySet());
            this.untilConsumed.clear();
        }
        this.untilConsumed.put(id, obj);
    }

    public Object getObjectWithID(Object id) {
        return this.idHolder.get(id);
    }

    public Object consumeObject(Object id) {
        return this.untilConsumed.remove(id);
    }

    public void close() {
        this.idHolder.clear();
    }
}

