/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.sequence;

import com.manageengine.apminsight.agent.config.AbstractSequenceConfig;
import com.manageengine.apminsight.agent.config.ApplicationConfig;
import com.manageengine.apminsight.agent.context.ContextInfoManager;
import com.manageengine.apminsight.agent.sequence.SequenceBag;
import com.manageengine.apminsight.agent.sequence.SequenceType;
import com.manageengine.apminsight.agent.tracing.exception.ErrorRecord;
import com.manageengine.apminsight.agent.trackers.AbstractRootTracker;
import com.manageengine.apminsight.agent.trackers.CallerAsyncRootTracker;
import com.manageengine.apminsight.agent.trackers.RootTracker;
import com.manageengine.apminsight.agent.trackers.db.DatabaseTracker;
import java.util.List;
import java.util.Map;

public class SequenceHeader
implements Cloneable {
    private String unnormalizedSeqNameSpace;
    private SequenceType sequenceType;
    private ApplicationConfig applicationConfig;
    private SequenceBag<ErrorRecord> errorRecords;
    private RootTracker rootTracker;
    private long seqCpuTimeInNanoSec = -1L;
    private long seqMemoryAllocInBytes = -1L;
    private String sequenceThreadName;
    private long sequenceThreadId = -1L;
    private DatabaseTracker recentDelayedSql;
    private int[] trackersCount;
    private Map<String, List<String>> customParams;
    private String contextName;
    private List<CallerAsyncRootTracker> asyncTrackerList;

    public String getUnnormalizedSeqNameSpace() {
        return this.unnormalizedSeqNameSpace;
    }

    public void setUnnormalizedSeqNameSpace(String sequenceNameSpace) {
        this.unnormalizedSeqNameSpace = sequenceNameSpace;
    }

    public SequenceType getSequenceType() {
        return this.sequenceType;
    }

    public void setSequenceType(SequenceType sequenceType) {
        this.sequenceType = sequenceType;
    }

    public SequenceBag<ErrorRecord> getErrorRecords() {
        return this.errorRecords;
    }

    public void setErrorRecords(SequenceBag<ErrorRecord> errorRecords) {
        this.errorRecords = errorRecords;
    }

    public RootTracker getRootTracker() {
        return this.rootTracker;
    }

    public void setRootTracker(RootTracker rootTracker) {
        this.rootTracker = rootTracker;
    }

    public long getSeqCpuTimeInNanoSec() {
        return this.seqCpuTimeInNanoSec;
    }

    public void setSeqCpuTimeInNanoSec(long seqCpuTimeInNanoSec) {
        this.seqCpuTimeInNanoSec = seqCpuTimeInNanoSec;
    }

    public long getSeqMemoryAllocInBytes() {
        return this.seqMemoryAllocInBytes;
    }

    public void setSeqMemoryAllocInBytes(long seqMemoryAllocInBytes) {
        this.seqMemoryAllocInBytes = seqMemoryAllocInBytes;
    }

    public String getSequenceThreadName() {
        return this.sequenceThreadName;
    }

    public void setSequenceThreadName(String sequenceThreadName) {
        this.sequenceThreadName = sequenceThreadName;
    }

    public long getSequenceThreadId() {
        return this.sequenceThreadId;
    }

    public void setSequenceThreadId(long sequenceThreadId) {
        this.sequenceThreadId = sequenceThreadId;
    }

    public boolean isSequenceErroneous() {
        return this.errorRecords != null && this.errorRecords.size() > 0 || this.rootTracker.isErrorTxn();
    }

    public DatabaseTracker getRecentDelayedSql() {
        return this.recentDelayedSql;
    }

    public void setRecentDelayedSql(DatabaseTracker dbTracker) {
        this.recentDelayedSql = dbTracker;
    }

    public int[] getTrackersCount() {
        return this.trackersCount;
    }

    public int getTotalTrackersCount() {
        return this.trackersCount != null ? this.trackersCount[0] + this.trackersCount[1] + this.trackersCount[2] : 0;
    }

    public void setTrackersCount(int[] trackersCount) {
        this.trackersCount = trackersCount;
    }

    public Map<String, List<String>> getCustomParams() {
        return this.customParams;
    }

    public void setCustomParams(Map<String, List<String>> customParams) {
        this.customParams = customParams;
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public String toString() {
        return this.unnormalizedSeqNameSpace + '(' + super.toString() + ')';
    }

    public SequenceHeader clone() throws CloneNotSupportedException {
        return (SequenceHeader)super.clone();
    }

    public ApplicationConfig getApplicationConfig() {
        return this.applicationConfig;
    }

    public void setApplicationConfig(ApplicationConfig applicationConfig) {
        this.applicationConfig = applicationConfig;
    }

    public AbstractSequenceConfig getSequenceConfig() {
        if (this.applicationConfig == null) {
            this.applicationConfig = ContextInfoManager.getInstance().getDefaultContextInfo().getConfig();
        }
        return this.sequenceType == SequenceType.WEB_HTTP ? this.applicationConfig.getWebSeqConfig() : this.applicationConfig.getBackgroundSeqConfig();
    }

    public List<CallerAsyncRootTracker> getAsyncTrackersList() {
        return this.asyncTrackerList;
    }

    public void setAsyncTrackerBag(List<CallerAsyncRootTracker> asyncTrackerList) {
        this.asyncTrackerList = asyncTrackerList;
    }

    public boolean isAsyncSequence() {
        return this.asyncTrackerList != null;
    }

    public void addAsyncTimeToTotalTime(long maxAsyncEndtime) {
        long rootEndtime = this.rootTracker.getStartTime() + (long)this.rootTracker.getDuration();
        if (maxAsyncEndtime > rootEndtime) {
            ((AbstractRootTracker)this.rootTracker).updateTotalTime(maxAsyncEndtime);
        }
    }
}

