/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.sequence;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.sequence.SequenceHeader;
import com.manageengine.org.apache.logging.log4j.Level;
import java.util.concurrent.ArrayBlockingQueue;

public class SequenceHeaderQueue {
    private static ArrayBlockingQueue<SequenceHeader> q;

    private static void init() {
        int size = JavaAgent.getInstance().agentConfig.getTrackerStoreSize();
        q = new ArrayBlockingQueue(size);
        JavaAgent.logger.info("SequenceHeaderQueue initialized with size: " + size);
    }

    public static boolean add(SequenceHeader sequenceHeader) {
        try {
            return q.add(sequenceHeader);
        }
        catch (Exception e) {
            JavaAgent.logger.log(Level.WARN, "Dropping txn \"{}\" due to SequenceHeaderQueue overflow. Current size: {}, Exception: {}", sequenceHeader.getRootTracker().getSequenceNameSpace(), q.size(), e.getMessage());
            return false;
        }
    }

    public static void clean() {
        q.clear();
        JavaAgent.logger.info("SequenceStore with occupied size: {} cleaned", q.size());
    }

    public static int getOccupiedSize() {
        return q.size();
    }

    public static SequenceHeader take() throws InterruptedException {
        return q.take();
    }

    static {
        SequenceHeaderQueue.init();
    }
}

