/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.sequence;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.context.ContextInfoManager;
import com.manageengine.apminsight.agent.instrumentation.interceptor.BasicPointcutProperties;
import com.manageengine.apminsight.agent.sequence.SequenceHeader;
import com.manageengine.apminsight.agent.sequence.SequenceTrace;
import com.manageengine.apminsight.agent.sequence.SequenceType;
import com.manageengine.apminsight.agent.trackers.AbstractRootTracker;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SequenceTraceStore {
    private static Map<String, SequenceTrace> store = new ConcurrentHashMap<String, SequenceTrace>();
    private static SequenceTrace overflowInformer = null;

    static synchronized SequenceTrace createOverflowInformer() {
        if (overflowInformer != null) {
            return overflowInformer;
        }
        AbstractRootTracker rootTracker = new AbstractRootTracker(new BasicPointcutProperties("0verf10w", "0verf10w"), null, null){

            @Override
            public String assignSequenceName() {
                this.seqName = "0verf10w";
                return this.seqName;
            }

            @Override
            public String getSequenceNameSpace() {
                return this.getSequenceName();
            }

            @Override
            public SequenceType getSequenceType() {
                return null;
            }

            @Override
            public String getContextPath() {
                return null;
            }
        };
        rootTracker.quit(-1, null);
        SequenceHeader sh = new SequenceHeader();
        sh.setApplicationConfig(ContextInfoManager.getInstance().getDefaultContextInfo().getConfig());
        sh.setRootTracker(rootTracker);
        sh.setSequenceType(SequenceType.BACKGROUND);
        overflowInformer = new SequenceTrace(sh, 0);
        return overflowInformer;
    }

    protected static SequenceTrace getTraceStoreOverFlowInformer() {
        return overflowInformer == null ? SequenceTraceStore.createOverflowInformer() : overflowInformer;
    }

    public List<SequenceTrace> getSequenceTracesToSend() {
        ArrayList<SequenceTrace> ttToSend = new ArrayList<SequenceTrace>();
        ttToSend.addAll(store.values());
        store.clear();
        return ttToSend;
    }

    public static SequenceTrace get(String seqTraceName) {
        return store.get(seqTraceName);
    }

    public static boolean put(String seqTraceName, SequenceTrace seqTrace) {
        if (SequenceTraceStore.isOverflow()) {
            return false;
        }
        store.put(seqTraceName, seqTrace);
        return true;
    }

    public static boolean constructTraceAndPut(String seqTraceName, SequenceHeader sh, int traceReason, boolean forceCreate) {
        if (!forceCreate && SequenceTraceStore.isOverflow()) {
            return false;
        }
        SequenceTrace seqTrace = new SequenceTrace(sh, traceReason);
        store.put(seqTraceName, seqTrace);
        return true;
    }

    public static boolean constructTraceAndPut(String seqTraceName, SequenceHeader sh, int traceReason) {
        return SequenceTraceStore.constructTraceAndPut(seqTraceName, sh, traceReason, false);
    }

    private static boolean isOverflow() {
        int threshold;
        int size = store.size();
        if (size == (threshold = JavaAgent.getInstance().agentConfig.getSeqTraceStoreSize())) {
            store.put("0verf10w", SequenceTraceStore.getTraceStoreOverFlowInformer());
            JavaAgent.logger.warn("SequenceTraceStore OverFlow. Current limit is: " + threshold);
            return true;
        }
        return size > threshold;
    }

    public static SequenceTrace replace(String seqTraceName, SequenceTrace seqTrace) {
        return store.put(seqTraceName, seqTrace);
    }

    public static int getOccupiedSize() {
        return store.size();
    }

    public static void emptySequenceTraceStore() {
        store.clear();
        JavaAgent.logger.debug("SequenceTraceStore cleaned");
    }
}

