/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.sequence;

import com.manageengine.apminsight.agent.metric.TraceReason;
import java.util.HashSet;
import java.util.Set;

public class TransactionTraceProfile {
    private int duration = 0;
    private int sqlTime = 0;
    private int exceptionCount = 0;
    private int externalCallCount = 0;
    private Set<String> exceptionNameSet = new HashSet<String>();
    private int traceReason = 0;
    private boolean isDistributedTrace = false;

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public int getSqlTime() {
        return this.sqlTime;
    }

    public void addSQLTime(int sqlTime) {
        this.sqlTime += sqlTime;
    }

    public int getExceptionCount() {
        return this.exceptionCount;
    }

    public void setExceptionCount(int exceptionCount) {
        this.exceptionCount = exceptionCount;
    }

    public int getExternalCallCount() {
        return this.externalCallCount;
    }

    public void incrementExtCallCount() {
        ++this.externalCallCount;
    }

    public Set<String> getExceptionNameSet() {
        return this.exceptionNameSet;
    }

    public void addExceptionName(String exceptionName) {
        this.exceptionNameSet.add(exceptionName);
    }

    public void setIsDistributedTrace(boolean b) {
        this.isDistributedTrace = b;
    }

    public boolean isDistributedTrace() {
        return this.isDistributedTrace;
    }

    public int getTraceReason() {
        return this.traceReason;
    }

    public void setTraceReason(int traceReason) {
        this.traceReason = traceReason;
    }

    public boolean isHighProfile(TransactionTraceProfile txnTraceProfile) {
        if (!this.exceptionNameSet.containsAll(txnTraceProfile.exceptionNameSet)) {
            this.exceptionNameSet.addAll(txnTraceProfile.exceptionNameSet);
            this.traceReason = TraceReason.NEW_EXCEPTION.getValue();
            return true;
        }
        if (this.exceptionCount < txnTraceProfile.exceptionCount) {
            this.exceptionCount = txnTraceProfile.exceptionCount;
            this.traceReason = TraceReason.POINTCUT_EXPERIENCED_EXCEPTION.getValue();
            return true;
        }
        if (this.sqlTime < txnTraceProfile.sqlTime) {
            this.sqlTime = txnTraceProfile.sqlTime;
            this.traceReason = TraceReason.SQL_EXECUTION_DELAYED.getValue();
            return true;
        }
        if (this.externalCallCount < txnTraceProfile.externalCallCount) {
            this.externalCallCount = txnTraceProfile.externalCallCount;
            this.traceReason = TraceReason.HIGH_EXT_COMPONENT_THROUGHPUT.getValue();
            return true;
        }
        if (this.isDistributedTrace) {
            this.traceReason = TraceReason.DISTRIBUTED_TRACE_PRESENT.getValue();
            return true;
        }
        if (this.duration < txnTraceProfile.duration) {
            this.duration = txnTraceProfile.duration;
            this.traceReason = TraceReason.SEQUENCE_HIGH_RESPONSETIME.getValue();
            return true;
        }
        return false;
    }
}

