/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.sequence.process;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.sequence.SequenceHeader;
import com.manageengine.apminsight.agent.sequence.SequenceHeaderQueue;
import com.manageengine.apminsight.agent.tracing.AsyncTracerService;
import com.manageengine.apminsight.agent.trackers.CallerAsyncRootTracker;
import java.util.HashSet;
import java.util.concurrent.ArrayBlockingQueue;

public class AsyncSequenceProcessor
implements Runnable {
    private static ArrayBlockingQueue<SequenceHeader> queue = new ArrayBlockingQueue(200, true);

    @Override
    public void run() {
        try {
            AsyncTracerService.getInstance().invalidateDeadTrackers();
            HashSet waitingSeqHeaders = new HashSet();
            try {
                JavaAgent.logger.debug("Dumping Async queue. Size: " + queue.size());
                queue.drainTo(waitingSeqHeaders);
            }
            catch (Exception e) {
                JavaAgent.logger.warn("Error occurred while draining async queue Exception: {}. Queue size: {}. Processed: {}", e.getMessage(), queue.size(), waitingSeqHeaders.size());
            }
            int completed = 0;
            int waiting = 0;
            for (SequenceHeader seqHeader : waitingSeqHeaders) {
                boolean allTasksCompleted = true;
                long maxEndtime = 0L;
                for (CallerAsyncRootTracker asyncTracker : seqHeader.getAsyncTrackersList()) {
                    if (!asyncTracker.isTxnCompleted()) {
                        JavaAgent.logger.info("---- async not completd waiting" + asyncTracker.getSequenceName() + " " + asyncTracker.getPointcutProperties().getSignature());
                        allTasksCompleted = false;
                        ++waiting;
                        queue.add(seqHeader);
                        break;
                    }
                    asyncTracker.linkCalleeTracker();
                    maxEndtime = Math.max(maxEndtime, asyncTracker.getStartTime() + (long)asyncTracker.getDuration());
                }
                if (!allTasksCompleted) continue;
                if (JavaAgent.getInstance().agentConfig.shouldRtIncludeAsyncTime()) {
                    seqHeader.addAsyncTimeToTotalTime(maxEndtime);
                }
                SequenceHeaderQueue.add(seqHeader);
                ++completed;
            }
            JavaAgent.logger.debug("Async Sequence eviction process completed. Processed:{} Finished:{} Awaiting:{}", waitingSeqHeaders.size(), completed, waiting);
            waitingSeqHeaders.clear();
            waitingSeqHeaders = null;
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("Error in processing async sequences. Exception: " + th.getMessage(), th);
        }
    }

    public static boolean addToQueue(SequenceHeader seqHeader) {
        try {
            return queue.add(seqHeader);
        }
        catch (IllegalStateException ise) {
            JavaAgent.logger.warn("Async wait queue is full. Dropping txn:{} Current Size:{}", seqHeader.getRootTracker().getSequenceNameSpace(), queue.size());
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("Error occurred while adding txn to Async Queue. Exception: " + th.getMessage());
        }
        return false;
    }
}

