/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.sequence.process;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.metrics.ComponentMetric;
import com.manageengine.apminsight.agent.metrics.LogCountMetric;
import com.manageengine.apminsight.agent.metrics.MetricData;
import com.manageengine.apminsight.agent.sequence.SequenceBag;
import com.manageengine.apminsight.agent.sequence.SequenceHeader;
import com.manageengine.apminsight.agent.sequence.TransactionTraceProfile;
import com.manageengine.apminsight.agent.tracing.exception.ErrorRecord;
import com.manageengine.apminsight.agent.tracing.exception.FatalLogRecord;
import com.manageengine.org.apache.logging.log4j.Level;
import java.util.concurrent.TimeUnit;

public class SeqMiscellaneousMetricsGenerator {
    public static void produceMetrics(SequenceHeader sequenceHeader, TransactionTraceProfile txnTraceProfile, MetricData metricData) {
        try {
            SeqMiscellaneousMetricsGenerator.generateCpuMetric(sequenceHeader.getSeqCpuTimeInNanoSec(), (ComponentMetric)metricData);
            SeqMiscellaneousMetricsGenerator.generateExceptionMetric(txnTraceProfile, sequenceHeader.getErrorRecords(), (LogCountMetric)metricData);
        }
        catch (Throwable th) {
            JavaAgent.logger.log(Level.WARN, "[SeqMiscellaneousMetricsGenerator]", th);
        }
    }

    private static void generateCpuMetric(long threadCpuTimeInNanoSec, ComponentMetric cpuMetricData) {
        cpuMetricData.recordThreadCpuTime((int)TimeUnit.NANOSECONDS.toMillis(threadCpuTimeInNanoSec));
    }

    private static void generateExceptionMetric(TransactionTraceProfile txnTraceProfile, SequenceBag<ErrorRecord> errorRecords, LogCountMetric logCountMetricData) {
        if (errorRecords == null) {
            return;
        }
        txnTraceProfile.setExceptionCount(errorRecords.size());
        for (ErrorRecord errorRecord : errorRecords) {
            logCountMetricData.recordLogCountData(errorRecord instanceof FatalLogRecord, errorRecord.getThrowable());
            txnTraceProfile.addExceptionName(errorRecord.getThrowable().getThrowableClass());
        }
    }
}

