/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.service;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.config.JavaAgentConfig;
import com.manageengine.apminsight.agent.jvm.monitor.JvmMonitor;
import com.manageengine.apminsight.agent.sequence.process.SequenceProcessor;
import com.manageengine.apminsight.agent.service.JmxService;
import com.manageengine.apminsight.agent.smart.SmartSampler;
import com.manageengine.apminsight.agent.troubleshoot.DiagnosticInfoCollector;
import com.manageengine.org.apache.logging.log4j.Level;

public class ScheduledTasksHandler
implements Runnable {
    private static short cycleCount = 0;
    private JavaAgentConfig agentConfig = JavaAgent.getInstance().getAgentConfig();

    @Override
    public void run() {
        if (cycleCount % (this.agentConfig.getJvmPollingInterval() / 60) == 0) {
            try {
                JvmMonitor jvm = JvmMonitor.getInstance();
                jvm.startPolling();
                if (this.agentConfig.isSmartSamplingEnabled()) {
                    try {
                        new SmartSampler().check(jvm.getVmMetric().getMemoryUsed(), jvm.getThreadMetric().getcpuUtil(), this.agentConfig.getSmartSamplerMemoryThreshold(), this.agentConfig.getSmartSamplerCPUThreshold());
                    }
                    catch (Exception e) {
                        JavaAgent.logger.log(Level.WARN, "[SmartSampler] Error occurred while checking thresholds. Exception: " + e.getMessage(), e);
                    }
                }
                JmxService.getInstance().processJmxExtensions();
            }
            catch (Exception e) {
                JavaAgent.logger.log(Level.WARN, "[JVMMonitor] Exception in JVM polling. Message: " + e.getMessage(), e);
            }
        }
        if (cycleCount % 15 == 0) {
            SequenceProcessor.clearTransactionTraceProfiles();
            this.agentConfig.clearDropThreshold();
        }
        JavaAgent.getInstance().getClassRetransformEngine().retransformEscaped();
        if (cycleCount % 360 == 0 && this.agentConfig.isDiagnosticLoggingEnabled()) {
            new DiagnosticInfoCollector().collectInfo();
        }
        this.resetCycleCount();
    }

    private void resetCycleCount() {
        cycleCount = cycleCount == 1440 ? (short)0 : (short)(cycleCount + 1);
    }
}

