/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.service;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.util.EnvironmentUtil;
import com.manageengine.apminsight.agent.util.JarUtil;
import java.io.File;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class VulnerableJarVersionCollector {
    private static final VulnerableJarVersionCollector INSTANCE = new VulnerableJarVersionCollector();
    private Map<String, String> detectedJars = new HashMap<String, String>();

    private VulnerableJarVersionCollector() {
    }

    public static VulnerableJarVersionCollector getInstance() {
        return INSTANCE;
    }

    public void collectJarVersionIfVulnerable(String className, CodeSource codeSource) {
        if (codeSource == null) {
            return;
        }
        URL jarUrl = codeSource.getLocation();
        for (VulnerableJar jar : VulnerableJar.values()) {
            String version;
            if (!jar.containsClass(className) || this.detectedJars.get(jar.getName()) != null || (version = JarUtil.getJarVersionFromUrl(jarUrl)) == null) continue;
            this.detectedJars.put(jar.getName(), version);
        }
    }

    public Set<Map.Entry<String, String>> getAllDetectedJarVersions() {
        return this.detectedJars.entrySet();
    }

    public void collectUndetectedJarVersions() {
        try {
            ArrayList<VulnerableJar> undetectedJars = new ArrayList<VulnerableJar>();
            for (VulnerableJar jar : VulnerableJar.values()) {
                if (this.detectedJars.get(jar.getName()) != null) continue;
                undetectedJars.add(jar);
            }
            if (!undetectedJars.isEmpty()) {
                this.collectJarVersionFromJarsInEnv(undetectedJars);
            }
            if (!undetectedJars.isEmpty()) {
                this.collectJarVersionByClassloading(undetectedJars);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void collectJarVersionByClassloading(List<VulnerableJar> undetectedJars) {
        ClassLoader[] classLoaders = new ClassLoader[]{ClassLoader.getSystemClassLoader(), this.getClass().getClassLoader()};
        ArrayList<VulnerableJar> collected = new ArrayList<VulnerableJar>();
        block2: for (VulnerableJar vulnerableJar : undetectedJars) {
            for (String classToLoad : vulnerableJar.getCoreClasses()) {
                for (ClassLoader classLoader : classLoaders) {
                    try {
                        Class<?> clz = Class.forName(classToLoad, false, classLoader);
                        String version = clz.getPackage().getImplementationVersion();
                        if (version == null) continue;
                        collected.add(vulnerableJar);
                        this.detectedJars.put(vulnerableJar.getName(), version);
                        continue block2;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        undetectedJars.removeAll(collected);
    }

    private void collectJarVersionFromJarsInEnv(List<VulnerableJar> undetectedJars) {
        List<File> jarFiles = EnvironmentUtil.getAllJarsInEnv();
        JavaAgent.logger.info("[VulnerableJarVersionCollector] Checking all jars found in environment: " + jarFiles);
        ArrayList<VulnerableJar> collected = new ArrayList<VulnerableJar>();
        block2: for (VulnerableJar vulnerableJar : undetectedJars) {
            for (File file : jarFiles) {
                try {
                    String version;
                    JarFile jar = new JarFile(file);
                    Manifest manifest = jar.getManifest();
                    if (manifest == null) continue;
                    Attributes attributes = null;
                    if (!manifest.getEntries().isEmpty()) {
                        Iterator<Attributes> iterator = manifest.getEntries().values().iterator();
                        if (iterator.hasNext()) {
                            Attributes attr;
                            attributes = attr = iterator.next();
                        }
                    } else {
                        attributes = manifest.getMainAttributes();
                    }
                    if (attributes == null || !vulnerableJar.hasSameAttributesAs(attributes) || (version = JarUtil.getJarVersionFromManifestAttributes(attributes)) == null) continue;
                    collected.add(vulnerableJar);
                    this.detectedJars.put(vulnerableJar.getName(), version);
                    continue block2;
                }
                catch (Throwable throwable) {
                }
            }
        }
        undetectedJars.removeAll(collected);
    }

    private static enum VulnerableJar {
        LOG4J("Log4j", new String[]{" org/apache/log4j".trim(), " org/apache/logging/log4j".trim()}, new String[]{" org.apache.log4j.Logger".trim(), " org.apache.logging.log4j.core.Logger".trim()}){

            @Override
            public boolean hasSameAttributesAs(Attributes attributes) {
                String title = attributes.getValue("Implementation-Title");
                return title != null && (title.equals("log4j") || title.startsWith("Apache Log4j"));
            }
        }
        ,
        SPRING_CORE("Spring Core", new String[]{"org/springframework/core"}, new String[]{"org.springframework.core.env.EnvironmentCapable"}){

            @Override
            public boolean hasSameAttributesAs(Attributes attributes) {
                String title = attributes.getValue("Implementation-Title");
                return title != null && title.startsWith("spring-core");
            }
        }
        ,
        SPRING_CLOUD_FUNCTION("Spring Cloud Function", new String[]{"org/springframework/cloud/function"}, new String[]{"org.springframework.cloud.function.context.FunctionScan", "org.springframework.cloud.function.web.function.FunctionEndpointInitializer"}){

            @Override
            public boolean hasSameAttributesAs(Attributes attributes) {
                String title = attributes.getValue("Implementation-Title");
                return title != null && (title.startsWith("Spring Cloud Function") || title.startsWith("spring-cloud-function"));
            }
        };

        private final String name;
        private final String[] rootPackages;
        private final String[] coreClasses;

        private VulnerableJar(String name, String[] rootPackages, String[] coreClasses) {
            this.name = name;
            this.rootPackages = rootPackages;
            this.coreClasses = coreClasses;
        }

        public String getName() {
            return this.name;
        }

        public String[] getCoreClasses() {
            return this.coreClasses;
        }

        public boolean containsClass(String className) {
            for (String rootPackage : this.rootPackages) {
                if (!className.startsWith(rootPackage)) continue;
                return true;
            }
            return false;
        }

        public boolean hasSameAttributesAs(Attributes attributes) {
            return false;
        }
    }
}

