/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.service.profiler;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.config.JavaAgentConfig;
import com.manageengine.apminsight.agent.context.ContextInfoManager;
import com.manageengine.apminsight.agent.instrumentation.InterceptorDefinitionFactory;
import com.manageengine.apminsight.agent.logging.AgentLogger;
import com.manageengine.apminsight.agent.ondemand.OnDemandTask;
import com.manageengine.apminsight.agent.service.profiler.ProfilerDatav2;
import com.manageengine.apminsight.agent.service.profiler.ThreadSamplingServiceV2;
import com.manageengine.apminsight.agent.service.profiler.TransactionProfilerService;
import com.manageengine.apminsight.agent.thread.WorkerThreadFactory;
import com.manageengine.org.apache.logging.log4j.Level;
import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ThreadProfiler
extends OnDemandTask {
    private int samplingInterval;
    private int profilingDuration;
    private int numberOfThreads;
    private Thread profilingThread;
    private ProfilerDatav2 profilerData;
    private JavaAgentConfig agentConfig;
    private boolean isInterrupted = false;
    private final ProfilerType incomingProfilerType;
    private static ProfilerType currentlyRunningProfilerType;
    private static ThreadProfiler currentRunningProfiler;
    private static boolean isProfilerActive;
    private AgentLogger logger;
    private int topNThreads;
    private ScheduledExecutorService executorService;
    private TransactionProfilerService txnProfilerService;
    private static final int MAX_RETRIES = 3;
    private static final int RETRY_WAIT_TIME = 30;
    private static String taskName;
    private static OnDemandTask.TaskWeightage weightage;

    public ThreadProfiler() {
        super(taskName, weightage);
        this.init();
        this.incomingProfilerType = ProfilerType.SCHEDULED;
        this.numberOfThreads = 50;
        this.topNThreads = 20;
    }

    public ThreadProfiler(int profilingDuration, int samplingInterval, int topN) {
        super(taskName, weightage);
        this.init();
        this.profilingDuration = profilingDuration;
        this.samplingInterval = samplingInterval;
        this.topNThreads = topN < 0 ? 20 : topN;
        this.incomingProfilerType = ProfilerType.ON_DEMAND;
        this.numberOfThreads = -1;
    }

    private void init() {
        this.agentConfig = JavaAgent.getInstance().getAgentConfig();
        this.logger = this.agentConfig.getLogger();
    }

    @Override
    public void runTask() {
        if (this.incomingProfilerType == ProfilerType.SCHEDULED && !this.agentConfig.isThreadProfilingEnabled() || !ContextInfoManager.getInstance().getDefaultContextInfo().isActive()) {
            return;
        }
        this.logger.info("Incoming thread profiler type: " + (Object)((Object)this.incomingProfilerType) + " awating go ahead signal");
        if (this.getGoAheadSignal()) {
            this.startProfiler();
        }
    }

    private boolean getGoAheadSignal() {
        if (isProfilerActive) {
            if (currentlyRunningProfilerType == ProfilerType.ON_DEMAND) {
                this.logger.info("[ThreadProfiler] ON_DEMAND profiling in progress, cannot start another profiler task");
                return false;
            }
            return this.incomingProfilerType == ProfilerType.ON_DEMAND ? currentRunningProfiler.stopProfiler() : false;
        }
        return true;
    }

    private void initializeProfiler() {
        int mod;
        if (this.incomingProfilerType == ProfilerType.SCHEDULED) {
            this.profilingDuration = this.agentConfig.getThreadProfilingDuration();
            this.samplingInterval = this.agentConfig.getThreadSamplingInterval();
        }
        if (this.profilingDuration < 120) {
            this.profilingDuration = 120;
            this.logger.info("Thread profiling duration set too low. Resetting to 120 seconds");
        }
        if ((mod = this.profilingDuration / 600) == 0) {
            if (this.samplingInterval < 60) {
                this.samplingInterval = 60;
            }
        } else if (mod == 1) {
            if (this.samplingInterval < 120) {
                this.samplingInterval = 120;
            }
        } else if (this.samplingInterval < 180) {
            this.samplingInterval = 180;
        }
        currentlyRunningProfilerType = this.incomingProfilerType;
        currentRunningProfiler = this;
        isProfilerActive = true;
        Thread.currentThread().setName("apminsight-" + currentlyRunningProfilerType.toString() + "-profiler");
        this.profilingThread = Thread.currentThread();
        this.profilerData = new ProfilerDatav2(this.agentConfig.getProfilingStacktraceDepth(), this.topNThreads);
        if (currentlyRunningProfilerType == ProfilerType.ON_DEMAND) {
            this.executorService = Executors.newSingleThreadScheduledExecutor(WorkerThreadFactory.getInstance());
            this.txnProfilerService = new TransactionProfilerService(this.profilerData);
            this.executorService.scheduleWithFixedDelay(this.txnProfilerService, 0L, 2L, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startProfiler() {
        block32: {
            try {
                block33: {
                    this.initializeProfiler();
                    this.logger.info(this.incomingProfilerType.toString() + " Thread Profiling has started. Profiling Duration: " + this.profilingDuration / 60 + " minutes Sampling intervals: " + this.samplingInterval / 60 + " minutes");
                    int numberOfSamples = (int)(Math.floor(this.profilingDuration / this.samplingInterval) + 1.0);
                    while (--numberOfSamples > -1 && !this.isInterrupted) {
                        try {
                            boolean saveThisDump = currentlyRunningProfilerType == ProfilerType.ON_DEMAND && numberOfSamples % 2 == 0 && this.profilerData.isDumpSpaceAvailable();
                            ThreadSamplingServiceV2 sampler = new ThreadSamplingServiceV2(this.profilerData, this.numberOfThreads, this.topNThreads, saveThisDump);
                            Thread samplingThread = WorkerThreadFactory.getInstance().newThread(sampler, "thread-sampler");
                            samplingThread.start();
                            if (numberOfSamples > 0) {
                                boolean pollNextSample = this.waitBeforeSample(this.samplingInterval);
                                if (pollNextSample) continue;
                                break;
                            }
                            samplingThread.join();
                        }
                        catch (InterruptedException ie) {
                            this.isInterrupted = true;
                        }
                        catch (Throwable th) {
                            this.logger.log(Level.WARN, "Error occurred during thread sampling. Exception: " + th.getMessage());
                        }
                    }
                    if (this.isInterrupted) {
                        this.resetProfiler();
                        this.logger.info(this.incomingProfilerType.toString() + " Thread Profiling interrupted. Profiling stopped and reset.");
                        return;
                    }
                    if (this.executorService != null) {
                        this.executorService.shutdownNow();
                    }
                    this.logger.info(this.incomingProfilerType.toString() + " Thread Profiling has completed.");
                    if (this.profilerData.isEmpty()) break block33;
                    if (currentlyRunningProfilerType == ProfilerType.ON_DEMAND) {
                        block31: {
                            File pTree = null;
                            try {
                                pTree = new File(JavaAgent.getInstance().getAgentConfig().getInstanceDir(), "profilerData.txt");
                                FileWriter writer = new FileWriter(pTree);
                                this.profilerData.writeJSONString(writer);
                                writer.close();
                                HashMap<String, File> allData = new HashMap<String, File>();
                                allData.put("pTree", pTree);
                                Iterator<File> iterator = this.profilerData.getSavedDumps().iterator();
                                int i = 1;
                                while (iterator.hasNext()) {
                                    allData.put("dump" + i, iterator.next());
                                    ++i;
                                }
                                for (i = 0; i < 3; ++i) {
                                    try {
                                        JavaAgent.getInstance().getAgentService().sendMultipleFilesToServer(ContextInfoManager.getInstance().getDefaultContextInfo(), "thread_profiler_v2", allData);
                                        this.logger.log(Level.INFO, (Object)((Object)currentlyRunningProfilerType) + " Thread profiler data sent to server successfully.");
                                        break;
                                    }
                                    catch (Throwable th) {
                                        this.logger.warn("Profiler Data communication failed. ", th);
                                        this.logger.warn("Retrying.. {}/{} after {} seconds", i + 1, 3, 30);
                                        try {
                                            Thread.sleep(30000L);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            // empty catch block
                                        }
                                        continue;
                                    }
                                }
                                if (pTree == null) break block31;
                                pTree.delete();
                            }
                            catch (Throwable th) {
                                try {
                                    this.logger.log(Level.WARN, "Unable to send profiler data to server, error occurred. " + th.getMessage(), th);
                                }
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                                finally {
                                    if (pTree != null) {
                                        pTree.delete();
                                    }
                                    for (File dump : this.profilerData.getSavedDumps()) {
                                        dump.delete();
                                    }
                                    this.logger.info("Removed all local dumps/files after sending them to our servers.");
                                }
                            }
                        }
                        for (File dump : this.profilerData.getSavedDumps()) {
                            dump.delete();
                        }
                        this.logger.info("Removed all local dumps/files after sending them to our servers.");
                    }
                    this.logger.debug((Object)((Object)this.incomingProfilerType) + " Profiler Total Call count: " + this.profilerData.getTotalCallCount());
                    if (JavaAgent.getInstance().agentConfig.isKnownDispatcher) {
                        Map<String, String> markedForInstrumentation = this.profilerData.getMarkedClassesForInstrumentation();
                        if (!markedForInstrumentation.isEmpty()) {
                            this.logger.info("Profiled and marked methods to be (re)transformed: " + markedForInstrumentation);
                            InterceptorDefinitionFactory.getInstance().sanitizeInterceptorDefinitions(markedForInstrumentation, false);
                        }
                    } else {
                        this.logger.info("UNKNOWN app server, skipping auto-instrumentation to maintain monitoring integrity.");
                    }
                    break block32;
                }
                this.logger.info("Profiler data is empty, no transactions happened during sampling. Sampling Interval: " + this.samplingInterval + "seconds");
            }
            catch (Throwable th) {
                this.logger.log(Level.WARN, "Error occurred in thread profiler task " + this.incomingProfilerType.toString(), th);
            }
            finally {
                this.resetProfiler();
            }
        }
    }

    private boolean waitBeforeSample(int samplingInterval) throws InterruptedException {
        for (int minutesToWait = (int)Math.ceil((double)samplingInterval / 60.0); minutesToWait > 0; --minutesToWait) {
            Thread.sleep(60000L);
            if (!this.isInterrupted) continue;
            return false;
        }
        return true;
    }

    public boolean stopProfiler() {
        try {
            if (currentlyRunningProfilerType == ProfilerType.ON_DEMAND) {
                this.logger.warn("On-Demand profiling in progress, cannot stop the profiling.");
                return false;
            }
            this.abortTask();
        }
        catch (Throwable th) {
            this.logger.log(Level.WARN, "Error in stopping thread profiler. Exception: " + th.getMessage(), th);
            return false;
        }
        return true;
    }

    @Override
    public boolean abortTask() {
        try {
            if (!isProfilerActive) {
                return true;
            }
            this.logger.info((Object)((Object)currentlyRunningProfilerType) + " profiler is running, force stopping it");
            this.profilingThread.interrupt();
            this.isInterrupted = true;
            isProfilerActive = false;
            currentRunningProfiler = null;
            if (this.executorService != null) {
                this.executorService.shutdownNow();
            }
            if (this.profilerData != null) {
                for (File dump : this.profilerData.getSavedDumps()) {
                    dump.delete();
                }
            }
            this.logger.info((Object)((Object)currentlyRunningProfilerType) + " Thread profiler has been force stopped successfully.");
            currentlyRunningProfilerType = null;
            return true;
        }
        catch (Throwable th) {
            this.logger.log(Level.WARN, "Unable to force stop thread profiler.", th);
            return false;
        }
    }

    public static boolean isProfilerActive() {
        return isProfilerActive;
    }

    public static ProfilerType getCurrentProfilerType() {
        return currentlyRunningProfilerType;
    }

    private void resetProfiler() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
        if (this.incomingProfilerType == currentlyRunningProfilerType) {
            currentlyRunningProfilerType = null;
            isProfilerActive = false;
        }
        currentRunningProfiler = null;
        this.isInterrupted = false;
        this.profilingThread = null;
        this.profilerData = null;
        if (this.txnProfilerService != null) {
            this.txnProfilerService.reset();
            this.txnProfilerService = null;
        }
    }

    static {
        taskName = "thread-profiler";
        weightage = OnDemandTask.TaskWeightage.HEAVY;
    }

    protected static enum ProfilerType {
        ON_DEMAND,
        SCHEDULED;

    }
}

