/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.service.profiler;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.jvm.monitor.ThreadMxBeanUtil;
import com.manageengine.apminsight.agent.service.profiler.ProfilerDatav2;
import com.manageengine.apminsight.agent.service.profiler.ThreadProfiler;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class TransactionProfilerService
implements Runnable {
    private static int txnCount = 0;
    private static final int MAX_TXN_COUNT = 10;
    private static volatile Set<Long> txnThreadIds = new HashSet<Long>();
    private ProfilerDatav2 profilerData;

    public TransactionProfilerService(ProfilerDatav2 profilerData) {
        this.profilerData = profilerData;
    }

    @Override
    public void run() {
        Thread.currentThread().setName("apminsight-txn-thread-profiler");
        HashSet<Long> threadIds = new HashSet<Long>(txnThreadIds);
        Iterator iterator = threadIds.iterator();
        while (iterator.hasNext()) {
            long threadId = (Long)iterator.next();
            try {
                this.profilerData.addStackTrace(ThreadMxBeanUtil.getStackTrace(threadId));
            }
            catch (Throwable th) {
                JavaAgent.logger.warn("Unable to profile thread id " + threadId, th);
            }
        }
        JavaAgent.logger.debug("[TxnProfilerService] Tranasction profiling is completed for " + threadIds.size() + " transactions");
    }

    public static boolean addTxnToProfiler(long threadId) {
        if (!ThreadProfiler.isProfilerActive() || ThreadProfiler.getCurrentProfilerType() != ThreadProfiler.ProfilerType.ON_DEMAND) {
            return false;
        }
        if (!txnThreadIds.contains(threadId) && txnCount < 10) {
            txnThreadIds.add(threadId);
            ++txnCount;
            return true;
        }
        return false;
    }

    public static void removeTxnFromProfiler(long threadId) {
        txnThreadIds.remove(threadId);
    }

    public void reset() {
        txnCount = 0;
        txnThreadIds.clear();
        this.profilerData = null;
    }
}

