/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.smart;

import com.manageengine.apminsight.agent.JavaAgent;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class SmartPackageFilter {
    private static SmartPackageFilter packageFilter;
    private Set<String> userPackages = new HashSet<String>();
    private static final String PKGS_TO_IGNORE = "com.manageengine.apminsight.agent.+|com.manageengine.org.+|java.+|jdk.+|com.sun.+|sun.+|org.apache.+|org.springframework.+|org.slf4j.+|org.jboss.+|org.eclipse.jetty.+|com.ibm.+|weblogic.+|com.mysql.+|org.postgresql.jdbc.+|com.yugabyte.jdbc.+|oracle.jdbc.+|com.ibm.db2.+|com.microsoft.sqlserver.+|com.mongodb.+|com.datastax.driver.+|org.xml.+|com.google.+";

    private SmartPackageFilter() {
    }

    public static SmartPackageFilter getInstance() {
        if (packageFilter == null) {
            packageFilter = new SmartPackageFilter();
        }
        return packageFilter;
    }

    public boolean isUserPackage(String className) {
        return Pattern.matches(PKGS_TO_IGNORE, className) ? false : this.userPackages.contains(this.getPackage(className));
    }

    public void addUserPackage(String className) {
        if (JavaAgent.getInstance().agentConfig.isSmartPackageFilterEnabled() && !Pattern.matches(PKGS_TO_IGNORE, className)) {
            this.userPackages.add(this.getPackage(className));
        }
    }

    public boolean isExcludedPackage(String name) {
        return Pattern.matches(PKGS_TO_IGNORE, name);
    }

    private String getPackage(String className) {
        int index = (className = className.replace('.', '/')).indexOf(47, className.indexOf(47) + 1);
        if (index == -1) {
            return className;
        }
        index = className.indexOf(47, index + 1);
        return index == -1 ? className.substring(0, className.lastIndexOf(47)) : className.substring(0, index);
    }
}

