/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.thread;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class WorkerThreadFactory
implements ThreadFactory {
    static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
    final AtomicInteger threadNumber = new AtomicInteger(1);
    final String namePrefix;
    private static WorkerThreadFactory threadFactory = null;
    private Set<Long> threadIds = new HashSet<Long>();

    private WorkerThreadFactory() {
        this.namePrefix = "apminsight-";
    }

    public static WorkerThreadFactory getInstance() {
        if (threadFactory == null) {
            threadFactory = new WorkerThreadFactory();
        }
        return threadFactory;
    }

    @Override
    public Thread newThread(Runnable r) {
        String sufix = new StringBuffer().append(POOL_NUMBER.getAndIncrement()).append("-thread-").append(this.threadNumber.getAndIncrement()).toString();
        return this.newThread(r, sufix);
    }

    public Thread newThread(Runnable r, String threadSufixName) {
        Thread t = new Thread(r, this.namePrefix + threadSufixName);
        t.setDaemon(true);
        this.threadIds.add(t.getId());
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }

    public boolean isAgentThread(long id) {
        return this.threadIds.contains(id);
    }

    public boolean isAgentThread(String threadName) {
        return threadName.startsWith(this.namePrefix);
    }

    public Long[] getAgentThreadIds() {
        return this.threadIds.toArray(new Long[this.threadIds.size()]);
    }
}

