/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.threads;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.context.ContextInfoManager;
import com.manageengine.apminsight.agent.exception.FatalException;
import com.manageengine.apminsight.agent.exception.MalformedException;
import com.manageengine.apminsight.agent.jvm.monitor.ThreadMxBeanUtil;
import com.manageengine.apminsight.agent.logging.AgentLogger;
import com.manageengine.apminsight.agent.ondemand.OnDemandTask;
import com.manageengine.apminsight.agent.service.AgentServiceConstants;
import com.manageengine.org.apache.logging.log4j.Level;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.util.HashMap;

public class ThreadDumpService
extends OnDemandTask
implements AgentServiceConstants {
    private boolean isDumpToFile = false;
    private String actionId;
    private AgentLogger logger;

    public ThreadDumpService(boolean dumpToFile, String actionId) {
        super("thread-dump-service", OnDemandTask.TaskWeightage.LITE);
        this.isDumpToFile = dumpToFile;
        this.actionId = actionId;
        this.logger = JavaAgent.logger;
    }

    @Override
    public void runTask() {
        try {
            this.logger.info("[Thread Dump] Received request to initiate thread dump. Action id: " + this.actionId);
            ThreadInfo[] dump = ThreadMxBeanUtil.dumpAllThreads(true);
            if (this.isDumpToFile) {
                this.dumpToFile(dump);
            } else {
                this.sendToServer(dump);
            }
        }
        catch (Throwable th) {
            this.logger.log(Level.WARN, "[Thread Dump] Exception occurred while running thread dump request, sending failure response to server. Exception: ", th);
            HashMap<String, Object> failureData = new HashMap<String, Object>();
            failureData.put("action.id", this.actionId);
            failureData.put("isSuccessful", false);
            failureData.put("reason", th.getLocalizedMessage());
            try {
                JavaAgent.getInstance().getAgentService().sendITAutomationActionResponse(ContextInfoManager.getInstance().getDefaultContextInfo(), "thread_dump", this.actionId, failureData);
                this.logger.info("[Thread Dump] Failure response sent to server successfully.");
            }
            catch (Exception ex) {
                this.logger.log(Level.WARN, "[Thread Dump] Unable to send failure response to server. Exception: ", ex);
            }
        }
    }

    private void sendToServer(ThreadInfo[] dump) throws IOException, MalformedException, FatalException, RuntimeException {
        File dumpFile = null;
        try {
            dumpFile = this.dumpToFile(dump);
            JavaAgent.getInstance().getAgentService().sendITAutomationActionResponse(ContextInfoManager.getInstance().getDefaultContextInfo(), "thread_dump", this.actionId, dumpFile);
            this.logger.info("[Thread Dump] Thread dump is sucessfully sent to server. Action completed: " + this.actionId);
        }
        finally {
            if (dumpFile != null && dumpFile.exists()) {
                dumpFile.delete();
                this.logger.info("[Thread Dump] Dumps are removed from local location");
            }
        }
    }

    public File dumpToFile(ThreadInfo[] dump) throws IOException {
        File file = new File(JavaAgent.getInstance().getAgentConfig().getInstanceDir(), "thread_dump_" + System.currentTimeMillis() + ".txt");
        FileWriter writer = new FileWriter(file);
        for (ThreadInfo info : dump) {
            writer.write(this.convertToString(info));
            writer.write(10);
        }
        writer.close();
        this.logger.info("[Thread Dump] Thread dump is taken and written to file " + file.getAbsolutePath());
        return file;
    }

    private String convertToString(ThreadInfo info) {
        StringBuilder sb = new StringBuilder("\"" + info.getThreadName() + "\" Id=" + info.getThreadId() + " " + (Object)((Object)info.getThreadState()));
        if (info.getLockName() != null) {
            sb.append(" on " + info.getLockName());
        }
        if (info.getLockOwnerName() != null) {
            sb.append(" owned by \"" + info.getLockOwnerName() + "\" Id=" + info.getLockOwnerId());
        }
        if (info.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (info.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append('\n');
        StackTraceElement[] stackTrace = info.getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement ste = stackTrace[i];
            sb.append("\tat " + ste.toString());
            sb.append('\n');
            if (i == 0 && info.getLockInfo() != null) {
                switch (info.getThreadState()) {
                    case BLOCKED: {
                        sb.append("\t-  blocked on " + info.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case WAITING: {
                        sb.append("\t-  waiting on " + info.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case TIMED_WAITING: {
                        sb.append("\t-  waiting on " + info.getLockInfo());
                        sb.append('\n');
                    }
                }
            }
            MonitorInfo[] monitorInfoArray = info.getLockedMonitors();
            int n = monitorInfoArray.length;
            for (int j = 0; j < n; ++j) {
                MonitorInfo monitorInfo = monitorInfoArray[j];
                if (monitorInfo.getLockedStackDepth() != i) continue;
                sb.append("\t-  locked " + monitorInfo);
                sb.append('\n');
            }
        }
        LockInfo[] lockInfos = info.getLockedSynchronizers();
        if (lockInfos.length > 0) {
            sb.append("\n\tNumber of locked synchronizers = " + lockInfos.length);
            sb.append('\n');
            for (LockInfo lockInfo : lockInfos) {
                sb.append("\t- " + lockInfo);
                sb.append('\n');
            }
        }
        sb.append('\n');
        return sb.toString();
    }

    @Override
    public boolean abortTask() {
        return true;
    }
}

