/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.tracing;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.smart.SmartPackageFilter;
import com.manageengine.org.json.simple.JSONArray;
import com.manageengine.org.json.simple.JSONStreamAware;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StackTrace
implements JSONStreamAware {
    private List<StackTraceItem> stackTrace;

    public StackTrace(StackTraceElement[] traceElements) {
        this(traceElements, true);
    }

    public StackTrace(StackTraceElement[] traceElements, boolean isFilterable) {
        if (traceElements == null || traceElements.length == 0) {
            this.stackTrace = new ArrayList<StackTraceItem>();
            return;
        }
        this.stackTrace = new ArrayList<StackTraceItem>();
        if (isFilterable) {
            this.getFilteredStack(traceElements);
        } else {
            this.getUnalteredStack(traceElements);
        }
    }

    private void getFilteredStack(StackTraceElement[] traceElements) {
        SmartPackageFilter smartFilter = SmartPackageFilter.getInstance();
        int dumpDepth = JavaAgent.getInstance().getAgentConfig().threadDumpMaxDepth;
        for (StackTraceElement stacktraceElement : traceElements) {
            if (this.stackTrace.size() == dumpDepth) break;
            if (!smartFilter.isUserPackage(stacktraceElement.getClassName())) continue;
            this.stackTrace.add(new StackTraceItem(stacktraceElement));
        }
        if (this.stackTrace.isEmpty()) {
            for (int i = 0; i < traceElements.length; ++i) {
                if (traceElements[i].getClassName().matches("com.manageengine.apminsight.agent.*|com.manageengine.org.*")) continue;
                this.stackTrace.add(new StackTraceItem(traceElements[i]));
                if (this.stackTrace.size() == dumpDepth) break;
            }
        }
    }

    private void getUnalteredStack(StackTraceElement[] traceElements) {
        for (StackTraceElement stacktraceElement : traceElements) {
            this.stackTrace.add(new StackTraceItem(stacktraceElement));
        }
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        JSONArray.writeJSONString(this.stackTrace, out);
    }

    public String toString() {
        return this.stackTrace.toString();
    }

    static class StackTraceItem
    implements JSONStreamAware {
        private final String declaringClass;
        private final String methodName;
        private final String fileName;
        private final int lineNumber;

        public StackTraceItem(StackTraceElement ste) {
            this(ste.getClassName(), ste.getMethodName(), ste.getFileName(), ste.getLineNumber());
        }

        public StackTraceItem(String declaringClass, String methodName, String fileName, int lineNumber) {
            this.declaringClass = declaringClass;
            this.methodName = methodName;
            this.fileName = fileName;
            this.lineNumber = lineNumber;
        }

        @Override
        public void writeJSONString(Writer out) throws IOException {
            JSONArray.writeJSONString(Arrays.asList(this.declaringClass, this.methodName, this.fileName, this.lineNumber), out);
        }

        public String toString() {
            return this.declaringClass + "." + this.methodName + "()(" + this.fileName + ":" + this.lineNumber + ")";
        }

        public int hashCode() {
            int result = 31 * this.declaringClass.hashCode() + this.methodName.hashCode();
            result = 31 * result + (this.fileName == null ? 0 : this.fileName.hashCode());
            result = 31 * result + this.lineNumber;
            return result;
        }

        public boolean equals(StackTrace st) {
            return this.toString().equals(st.toString());
        }
    }
}

