/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.tracing.exception;

import com.manageengine.apminsight.agent.tracing.StackTrace;

public class ErrorThrowable {
    private static final int MESSAGE_MAXLENGTH = 256;
    private String message;
    private StackTrace stackTrace;
    private String clzName;
    private int throwableObjHashCode;

    public ErrorThrowable(Throwable th) {
        if (th == null) {
            return;
        }
        this.message = th.getLocalizedMessage();
        if (this.message != null) {
            this.message = this.message.trim();
            if (this.message.length() > 256) {
                this.message = this.message.substring(0, 256 - "..".length()) + "..";
            }
        }
        this.stackTrace = new StackTrace(th.getStackTrace());
        this.clzName = th.getClass().getCanonicalName();
        if (this.clzName == null) {
            this.clzName = th.getClass().getName();
        }
        this.throwableObjHashCode = System.identityHashCode(th);
    }

    public String getThrowableLocalizedMessage() {
        return this.message;
    }

    public StackTrace getStackTrace() {
        return this.stackTrace;
    }

    public String getThrowableClass() {
        return this.clzName;
    }

    public int getThrowableObjHashCode() {
        return this.throwableObjHashCode;
    }

    public int hashCode() {
        return this.throwableObjHashCode;
    }

    public boolean equals(Object obj) {
        return this.throwableObjHashCode == ((ErrorThrowable)obj).throwableObjHashCode;
    }
}

