/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers;

import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.trackers.IteratorTracker;
import com.manageengine.apminsight.agent.trackers.LoopTracker;
import com.manageengine.apminsight.agent.trackers.Tracker;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractTracker
implements Tracker {
    protected PointcutProperties pointcutProperties;
    public AbstractTracker child;
    public AbstractTracker sibling;
    protected boolean isLeafTracker;
    public IteratorTracker iteratorTracker = null;
    List<LoopTracker> loopTrackers = null;

    protected AbstractTracker(PointcutProperties pointcutProperties) {
        this.pointcutProperties = pointcutProperties;
    }

    @Override
    public PointcutProperties getPointcutProperties() {
        return this.pointcutProperties;
    }

    @Override
    public Tracker getChild() {
        return this.child;
    }

    @Override
    public Tracker getSibling() {
        return this.sibling;
    }

    @Override
    public boolean isLeafTracker() {
        return this.isLeafTracker;
    }

    @Override
    public boolean isExternalTracker() {
        return this.pointcutProperties.getComponent().isExternal();
    }

    @Override
    public String getTrackerSignature() {
        return this.pointcutProperties.getSignature();
    }

    @Override
    public Map<String, Object> getMoreData(Map<String, Object> moreData) {
        return moreData;
    }

    public static AbstractTracker getLeafTracker(AbstractTracker source) {
        if (source == null) {
            return null;
        }
        while (source.child != null) {
            source = source.child;
        }
        return source;
    }

    @Override
    public String getNormalizedSignature() {
        return this.getTrackerSignature();
    }

    public void trackOpenedLoop(LoopTracker t) {
        if (this.loopTrackers == null) {
            this.loopTrackers = new ArrayList<LoopTracker>();
        }
        this.loopTrackers.add(t);
    }

    public boolean isLoopPresent(LoopTracker t) {
        return this.loopTrackers != null && this.loopTrackers.contains(t);
    }
}

