/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.metrics.ComponentMetric;
import com.manageengine.apminsight.agent.metrics.MetricData;
import com.manageengine.apminsight.agent.sequence.SequenceHeader;
import com.manageengine.apminsight.agent.trackers.AbstractTracker;
import com.manageengine.apminsight.agent.trackers.LoopTracker;
import com.manageengine.apminsight.agent.util.UUIDGenerator;

public class DefaultTracker
extends AbstractTracker {
    protected long startTime = System.currentTimeMillis();
    protected int duration;
    protected Throwable error;
    protected String spanID = UUIDGenerator.generateSpanID();
    protected String parentSpanId;

    public DefaultTracker(PointcutProperties interceptPointMetaData, Object thiz, Object[] args) {
        super(interceptPointMetaData);
    }

    @Override
    public String getSpanID() {
        return this.spanID;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    @Override
    public void quit(int opcode, Object returnValue) {
        this.quit();
    }

    @Override
    public void quit(Throwable th) {
        this.error = th;
        this.quit();
    }

    protected void quit() {
        if (this.loopTrackers != null) {
            this.loopTrackers.forEach(loopTracker -> JavaAgent.getHandler().endLoop((LoopTracker)loopTracker));
        }
        this.duration = (int)(System.currentTimeMillis() - this.startTime);
        if (this.duration < 0) {
            JavaAgent.logger.info("Duration -ve: " + this.pointcutProperties.getSignature());
        }
    }

    @Override
    public String getTrackerSignature() {
        String signature = this.pointcutProperties.getSignature();
        if (this.isErroneous()) {
            signature = signature + " Error: " + this.error.getClass().getSimpleName();
        }
        return signature;
    }

    @Override
    public boolean generateMetric(SequenceHeader seqHeader, int childDuration, MetricData metricData) {
        ((ComponentMetric)metricData).recordComponentData(this.pointcutProperties.getComponent(), this.duration - childDuration, this.isErroneous());
        return this.isMetricHolded();
    }

    @Override
    public boolean isMetricHolded() {
        return false;
    }

    @Override
    public Throwable getErrorCause() {
        return this.error;
    }

    @Override
    public boolean isErroneous() {
        return this.error != null;
    }

    public int hashCode() {
        return this.pointcutProperties.hashCode();
    }

    public boolean equals(Object obj) {
        return this.pointcutProperties.equals(((DefaultTracker)obj).pointcutProperties);
    }

    public String toString() {
        return this.getTrackerSignature();
    }

    @Override
    public String getParentSpanID() {
        return this.parentSpanId;
    }

    @Override
    public void setParentSpanID(String spanId) {
        this.parentSpanId = spanId;
    }
}

