/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.sequence.SequenceSpace;
import com.manageengine.apminsight.agent.trackers.AbstractTracker;
import com.manageengine.apminsight.agent.trackers.DefaultTracker;
import com.manageengine.apminsight.agent.trackers.LoopTracker;
import com.manageengine.apminsight.agent.trackers.Tracker;
import com.manageengine.apminsight.agent.trackers.db.DatabaseTracker;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class IteratorTracker
extends DefaultTracker {
    public AbstractTracker nominee;
    public IteratorTracker parent = null;
    public Deque<AbstractTracker> currTracker = new ArrayDeque<AbstractTracker>();
    public boolean isClosed = false;
    private int totalCount;
    private String signature = null;
    private int fatalCount;
    private Long startTime = null;
    private final Map<String, Object> additionalData = new HashMap<String, Object>();

    public IteratorTracker(String signature, PointcutProperties p) {
        super(p, null, null);
        this.signature = signature;
    }

    @Override
    public String getTrackerSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(this.totalCount);
        sb.append(" iterations] ");
        sb.append(this.signature == null ? this.pointcutProperties.getSignature() : this.signature);
        return sb.toString();
    }

    @Override
    public String getNormalizedSignature() {
        return this.signature == null ? this.pointcutProperties.getSignature() : this.signature;
    }

    @Override
    public Map<String, Object> getMoreData(Map<String, Object> addInfo) {
        addInfo.putAll(this.additionalData);
        return addInfo;
    }

    public boolean isNotTraceable(int trackerDropThreshold) {
        return this.getDuration() < trackerDropThreshold && !this.isExternalTracker() && !this.isErroneous();
    }

    public void start(AbstractTracker t) {
        t.iteratorTracker = this;
        this.isClosed = false;
        this.currTracker.add(t);
        this.startTime = t.getStartTime();
    }

    @Override
    public void quit() {
        try {
            AbstractTracker tracker = this.currTracker.pop();
            tracker.iteratorTracker = null;
            this.collectData(tracker);
            this.isClosed = true;
        }
        catch (Exception e) {
            JavaAgent.logger.warn("error in IteratorTracker.quit(), ", e);
        }
    }

    public void collectData(Tracker tracker) {
        try {
            this.totalCount = tracker instanceof LoopTracker ? (this.totalCount += ((LoopTracker)tracker).getIterationCount()) : ++this.totalCount;
            if (this.startTime == null) {
                this.startTime = tracker.getStartTime();
            }
            this.duration += tracker.getDuration();
            if (tracker.isErroneous()) {
                ++this.fatalCount;
                this.error = tracker.getErrorCause();
            }
            if (this.additionalData.isEmpty()) {
                tracker.getMoreData(this.additionalData);
            }
            if (tracker instanceof DatabaseTracker && !this.isTraceCollected() && (float)this.duration > SequenceSpace.SEQUENCE_BOOK.get().getConfig().getSqlTraceThreshold()) {
                this.additionalData.put("stacktrace", ((DatabaseTracker)((Object)tracker)).collectStackTrace());
            }
        }
        catch (Exception e) {
            JavaAgent.logger.info("Error in IteratorTracker.aggregateData()");
        }
    }

    private void aggregateAddnData(Map<String, Object> data) {
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            String key = entry.getKey();
            if (!this.additionalData.containsKey(key)) {
                this.additionalData.put(key, entry.getValue());
                continue;
            }
            Object value = entry.getValue();
            if (value instanceof Integer) {
                this.additionalData.put(key, (Integer)this.additionalData.get(key) + (Integer)value);
                continue;
            }
            Object oldValue = this.additionalData.get(key);
            if (oldValue instanceof Collection) {
                if (value instanceof Collection) {
                    ((Collection)this.additionalData.get(key)).addAll((Collection)value);
                    continue;
                }
                ((Collection)this.additionalData.get(key)).add(value);
                continue;
            }
            HashSet<Object> list = new HashSet<Object>();
            list.add(value);
            list.add(oldValue);
            this.additionalData.put(key, list);
        }
    }

    private boolean isTraceCollected() {
        return this.additionalData.containsKey("stacktrace");
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return false;
    }
}

