/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers;

import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.trackers.AbstractTracker;
import com.manageengine.apminsight.agent.trackers.DefaultTracker;
import com.manageengine.apminsight.agent.util.TraceTree;
import java.util.Map;

public class LoopTracker
extends DefaultTracker {
    private int iterationCount = 0;
    public TraceTree traceTree = new TraceTree(this);

    public LoopTracker(PointcutProperties pointcutProperties) {
        super(pointcutProperties, null, null);
    }

    public void transformChildTracker(DefaultTracker t) {
        this.traceTree.transformTracker(t);
    }

    public void cleanAndUpdate(AbstractTracker t) {
        this.traceTree.cleanAndUpdate(t);
    }

    public void addIteration() {
        ++this.iterationCount;
    }

    public boolean isTraceable() {
        return this.traceTree.isExternalCallCaptured() || this.duration > 10;
    }

    @Override
    public void quit() {
        super.quit();
        this.child = this.traceTree.firstTracker;
        --this.iterationCount;
    }

    @Override
    public String getTrackerSignature() {
        return "[" + this.getIterationCount() + " iterations] " + this.pointcutProperties.getSignature();
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    @Override
    public String getNormalizedSignature() {
        return this.pointcutProperties.getSignature();
    }

    @Override
    public Map<String, Object> getMoreData(Map<String, Object> moreData) {
        return moreData;
    }
}

