/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.background;

import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.metrics.MetricData;
import com.manageengine.apminsight.agent.metrics.ResponseTimeMetric;
import com.manageengine.apminsight.agent.sequence.SequenceHeader;
import com.manageengine.apminsight.agent.sequence.SequenceType;
import com.manageengine.apminsight.agent.trackers.AbstractRootTracker;

public class BackgroundSeqRootTracker
extends AbstractRootTracker {
    public BackgroundSeqRootTracker(PointcutProperties pointcutProperties, Object thiz, Object[] args) {
        super(pointcutProperties, thiz, args);
    }

    @Override
    public SequenceType getSequenceType() {
        return SequenceType.BACKGROUND;
    }

    @Override
    protected String assignSequenceName() {
        String interceptedClzName = this.pointcutProperties.getInterceptedClassName();
        try {
            this.seqName = interceptedClzName.substring(interceptedClzName.lastIndexOf(47) + 1) + '.' + this.pointcutProperties.getInterceptedMethodName();
        }
        catch (Exception e) {
            this.seqName = interceptedClzName;
        }
        this.hasMetric = true;
        return this.seqName;
    }

    @Override
    public String getSequenceNameSpace() {
        return this.getSequenceType().getSequenceNamespacePrefix() + this.getSequenceName();
    }

    @Override
    public boolean generateMetric(SequenceHeader seqHeader, int childTrackersDuration, MetricData metricData) {
        if (this.hasMetric) {
            if (this.isErroneous()) {
                ((ResponseTimeMetric)metricData).recordErroneousData(this.getDuration());
            } else {
                ((ResponseTimeMetric)metricData).recordData(this.getDuration());
            }
        }
        return this.hasMetric;
    }

    @Override
    public boolean isMetricHolded() {
        return this.hasMetric;
    }

    @Override
    public String getContextPath() {
        return "";
    }
}

