/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.cassandra;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.config.JavaAgentConfig;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.trackers.db.AbstractDBTracker;
import com.manageengine.org.apache.logging.log4j.Level;
import java.lang.reflect.Method;
import java.util.Collection;

public class CassandraTracker
extends AbstractDBTracker {
    private Object statement;

    public CassandraTracker(PointcutProperties pointcutProperties, Object thizObj, Object[] args) {
        super(pointcutProperties, thizObj, args);
        this.statement = args != null && args.length > 0 ? args[0] : null;
    }

    @Override
    public void quit(int opcode, Object returnValue) {
        super.quit(opcode, returnValue);
        if (JavaAgentConfig.captureHostDetails) {
            try {
                Method method = returnValue.getClass().getMethod("getExecutionInfo", new Class[0]);
                method.setAccessible(true);
                Object obj = method.invoke(returnValue, new Object[0]);
                method = obj.getClass().getMethod("getQueriedHost", new Class[0]);
                method.setAccessible(true);
                this.serverAddress = method.invoke(obj, new Object[0]).toString();
            }
            catch (Throwable th) {
                JavaAgent.logger.log(Level.WARN, "[CassandraTracker] Error while retrieving queried host. Exception: " + th.getMessage());
            }
        }
    }

    @Override
    public void quit(Throwable th) {
        super.quit(th);
        if (JavaAgentConfig.captureHostDetails) {
            try {
                Method m = th.getClass().getMethod("getHost", new Class[0]);
                this.serverAddress = m.invoke((Object)th, new Object[0]).toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected void quit() {
        super.quit();
        this.queries = this.extractQuery(this.statement);
        this.standardizeQueries();
        this.statement = null;
    }

    private String[] extractQuery(Object statement) {
        block7: {
            if (statement == null) {
                return null;
            }
            Class<?> statementClz = statement.getClass();
            String clzName = statementClz.getSimpleName();
            try {
                if (clzName.matches("BoundStatement")) {
                    Method m = statementClz.getMethod("preparedStatement", new Class[0]);
                    Object prepStatement = m.invoke(statement, new Object[0]);
                    m = prepStatement.getClass().getMethod("getQueryString", new Class[0]);
                    return new String[]{m.invoke(prepStatement, new Object[0]).toString()};
                }
                if (clzName.matches("BatchStatement")) {
                    Method m = statement.getClass().getMethod("getStatements", new Class[0]);
                    Collection batchStatements = (Collection)m.invoke(statement, new Object[0]);
                    if (batchStatements != null) {
                        String[] queries = new String[batchStatements.size()];
                        int i = 0;
                        for (Object batchStmt : batchStatements) {
                            queries[i++] = batchStmt.toString();
                        }
                        return queries;
                    }
                    break block7;
                }
                Method m = statement.getClass().getMethod("getQueryString", new Class[0]);
                return new String[]{(String)m.invoke(statement, new Object[0])};
            }
            catch (Exception e) {
                JavaAgent.logger.log(Level.WARN, "[CassandraTracker] Unable to fetch query from the statement object. Clz: {} Exception: {}", clzName, e.getMessage());
            }
        }
        return null;
    }
}

