/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.db;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.metric.MetricConstants;
import com.manageengine.apminsight.agent.metrics.ComponentMetric;
import com.manageengine.apminsight.agent.metrics.MetricData;
import com.manageengine.apminsight.agent.metrics.MetricName;
import com.manageengine.apminsight.agent.metrics.MetricType;
import com.manageengine.apminsight.agent.metrics.ResponseTimeMetric;
import com.manageengine.apminsight.agent.metrics.store.MetricStore;
import com.manageengine.apminsight.agent.metrics.store.MetricStoreController;
import com.manageengine.apminsight.agent.sequence.SequenceHeader;
import com.manageengine.apminsight.agent.sequence.SequenceSpace;
import com.manageengine.apminsight.agent.tracing.StackTrace;
import com.manageengine.apminsight.agent.trackers.DefaultTracker;
import com.manageengine.apminsight.agent.trackers.db.DatabaseTracker;
import com.manageengine.apminsight.agent.trackers.db.QueryInfo;
import com.manageengine.apminsight.agent.trackers.db.QueryLiteralRemover;
import com.manageengine.apminsight.agent.trackers.db.QueryParser;
import com.manageengine.apminsight.agent.trackers.external.IExternalTracker;
import com.manageengine.apminsight.agent.util.InetAddressUtil;
import com.manageengine.apminsight.agent.util.StringUtils;
import com.manageengine.org.apache.logging.log4j.Level;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

public abstract class AbstractDBTracker
extends DefaultTracker
implements IExternalTracker,
DatabaseTracker,
MetricConstants {
    protected String[] queries;
    protected String serverAddress;
    protected StackTraceElement[] stackTraceElements = null;
    protected boolean shouldRemoveQueryLiterals;
    protected int rowsCount = -1;
    protected int batchQueriesCount = -1;

    public AbstractDBTracker(PointcutProperties pointcutProps, Object thiz, Object[] args) {
        super(pointcutProps, thiz, args);
        this.isLeafTracker = true;
    }

    @Override
    protected void quit() {
        super.quit();
        try {
            SequenceSpace seqSpace = SequenceSpace.SEQUENCE_BOOK.get();
            if ((float)this.duration > seqSpace.getConfig().getSqlTraceThreshold()) {
                this.stackTraceElements = Thread.currentThread().getStackTrace();
                seqSpace.setRecentDelayedSql(this);
            }
            this.shouldRemoveQueryLiterals = seqSpace.getConfig().shouldRemoveQueryLiterals();
        }
        catch (Throwable e) {
            JavaAgent.logger.warn("Unable to dump thread stack trace. Exception: " + e.getMessage() + " Try adding permission to dump thread stack trace in your security policy");
        }
    }

    @Override
    public StackTrace collectStackTrace() {
        if (this.stackTraceElements == null) {
            this.stackTraceElements = Thread.currentThread().getStackTrace();
        }
        return new StackTrace(this.stackTraceElements);
    }

    protected void standardizeQueries() {
        if (this.queries != null) {
            for (int i = 0; i < this.queries.length; ++i) {
                this.queries[i] = QueryParser.standardizeQuery(this.queries[i], this.shouldRemoveQueryLiterals);
            }
        }
    }

    @Override
    public boolean generateMetric(SequenceHeader seqHeader, int childTrackersDuration, MetricData metricData) {
        this.serverAddress = InetAddressUtil.standardizeServerAddress(this.serverAddress);
        ((ComponentMetric)metricData).recordComponentData(this.pointcutProperties.getComponent(), this.serverAddress, this.duration - childTrackersDuration, this.isErroneous());
        if (this.isMetricHolded()) {
            String contextName = seqHeader.getContextName();
            String seqNameSpace = seqHeader.getRootTracker().getSequenceNameSpace();
            MetricStore metricStore = MetricStoreController.getMetricStore();
            String metricName_db_level = "db/all/all/dummy-db";
            ResponseTimeMetric metric_db_level = (ResponseTimeMetric)metricStore.getMetric(new MetricName(contextName, "", metricName_db_level){

                @Override
                public String getNameSpace() {
                    return this.getContextName();
                }
            }, MetricType.RESPONSETIME, false).getMetricData();
            metric_db_level.setContextName(contextName);
            if (this.isErroneous()) {
                metric_db_level.recordErroneousData(this.duration);
            } else {
                metric_db_level.recordData(this.duration);
            }
            this.duration /= this.queries.length;
            for (int i = 0; i < this.queries.length; ++i) {
                String query = this.queries[i];
                if (query == null) continue;
                try {
                    int bc;
                    if (this.shouldRemoveQueryLiterals) {
                        query = this.queries[i] = QueryLiteralRemover.removeLiterals(query);
                    }
                    QueryInfo queryInfo = QueryParser.getQueryInfo(query);
                    String metricName_opn_level = "";
                    String metricName_opn_table_level = "";
                    if (queryInfo != null) {
                        metricName_opn_level = "db/" + queryInfo.getOperation().toLowerCase(Locale.ENGLISH) + "/" + "all" + "/" + "dummy-db";
                        metricName_opn_table_level = "db/" + queryInfo.getOperation().toUpperCase(Locale.ENGLISH) + "/" + queryInfo.getTable() + "/" + "dummy-db";
                    } else {
                        if (!this.useOrginalQuery(query)) continue;
                        metricName_opn_level = "db/select/all/dummy-db";
                        metricName_opn_table_level = "db/" + query + "/" + " " + "/" + "dummy-db";
                    }
                    ResponseTimeMetric metric_opn_level = (ResponseTimeMetric)metricStore.getMetric(new MetricName(contextName, "", metricName_opn_level){

                        @Override
                        public String getNameSpace() {
                            return this.getContextName();
                        }
                    }, MetricType.RESPONSETIME, false).getMetricData();
                    metric_opn_level.setContextName(contextName);
                    ResponseTimeMetric metric_opn_table_level = (ResponseTimeMetric)metricStore.getMetric(contextName, seqNameSpace, metricName_opn_table_level, MetricType.RESPONSETIME, false).getMetricData();
                    metric_opn_table_level.setContextName(contextName);
                    if (this.isErroneous()) {
                        metric_opn_level.recordErroneousData(this.duration);
                        metric_opn_table_level.recordErroneousData(this.duration);
                    } else {
                        metric_opn_level.recordData(this.duration);
                        metric_opn_table_level.recordData(this.duration);
                    }
                    if (this.queries.length == 1 && this.batchQueriesCount > -1) {
                        for (bc = this.batchQueriesCount; bc > 1; --bc) {
                            metric_db_level.recordData(-1);
                            metric_opn_level.recordData(-1);
                            metric_opn_table_level.recordData(-1);
                        }
                    }
                    if (this.queries.length != 1 || this.batchQueriesCount <= -1) continue;
                    for (bc = this.batchQueriesCount; bc > 1; --bc) {
                        metric_db_level.recordData(-1);
                        metric_opn_level.recordData(-1);
                        metric_opn_table_level.recordData(-1);
                    }
                    continue;
                }
                catch (Exception e) {
                    String error = MessageFormat.format("Exception while generating metric for query: {0} Sequence: {1}", query, seqNameSpace);
                    JavaAgent.logger.log(Level.WARN, error, e);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public String getTrackerSignature() {
        StringBuilder signature = new StringBuilder();
        signature.append(this.pointcutProperties.getComponent());
        if (this.isMetricHolded()) {
            if (this.batchQueriesCount < 0) {
                QueryInfo queryInfo = QueryParser.getQueryInfo(this.queries[0]);
                if (queryInfo != null) {
                    signature.append(" - ");
                    signature.append(queryInfo.getOperation().toUpperCase(Locale.ENGLISH));
                    signature.append(" - ");
                    signature.append(queryInfo.getTable());
                } else {
                    signature.append(" Query");
                }
            } else {
                signature.append(" - BatchQuery: ");
                signature.append(this.batchQueriesCount);
                signature.append(" Queries");
            }
        } else {
            signature.append(" Query");
        }
        if (this.rowsCount > -1) {
            signature.append(" - Rows: " + this.rowsCount);
        }
        if (!StringUtils.isEmptyString(this.serverAddress)) {
            signature.append(" - ");
            try {
                signature.append(this.serverAddress.split("/")[1]);
            }
            catch (Exception e) {
                signature.append(this.serverAddress);
            }
        }
        if (this.isErroneous()) {
            signature.append(" Error: ");
            signature.append(this.error.getClass().getSimpleName());
        }
        return signature.toString();
    }

    @Override
    public String getNormalizedSignature() {
        StringBuilder signature = new StringBuilder();
        signature.append(this.pointcutProperties.getComponent());
        if (this.isMetricHolded()) {
            if (this.queries.length == 1) {
                QueryInfo queryInfo = QueryParser.getQueryInfo(this.queries[0]);
                if (queryInfo != null) {
                    signature.append(" - ");
                    signature.append(queryInfo.getOperation().toUpperCase(Locale.ENGLISH));
                    signature.append(" - ");
                    signature.append(queryInfo.getTable());
                } else {
                    signature.append(" Query");
                }
            } else {
                signature.append(" - BatchQuery: ");
                signature.append(this.queries.length);
                signature.append(" Queries");
            }
        } else {
            signature.append(" Query");
        }
        return signature.toString();
    }

    @Override
    public Map<String, Object> getMoreData(Map<String, Object> addInfo) {
        if (this.queries == null) {
            return addInfo;
        }
        String allQueries = "";
        HashSet<String> dbOperations = new HashSet<String>();
        for (String query : this.queries) {
            allQueries = allQueries + query + ";";
            QueryInfo queryInfo = QueryParser.getQueryInfo(query);
            if (queryInfo == null) continue;
            dbOperations.add(queryInfo.getOperation().toUpperCase() + "/" + queryInfo.getTable());
        }
        if (this.batchQueriesCount > -1 && this.queries.length == 1) {
            allQueries = "[Batch - " + this.batchQueriesCount + " " + (this.batchQueriesCount == 1 ? "time" : "times") + "] " + allQueries;
        }
        addInfo.put("query", allQueries);
        if (!dbOperations.isEmpty()) {
            addInfo.put("db_opn", dbOperations);
        }
        if (this.rowsCount > -1) {
            addInfo.put("rows", this.rowsCount);
        }
        if (!this.isErroneous()) {
            addInfo.put("stacktrace", new StackTrace(this.getStackTraceElement()));
        }
        return addInfo;
    }

    @Override
    public boolean isMetricHolded() {
        return this.queries != null;
    }

    @Override
    public StackTraceElement[] getStackTraceElement() {
        return this.stackTraceElements;
    }

    protected boolean useOrginalQuery(String query) {
        return query.length() <= 20;
    }

    @Override
    public String getServerAddress() {
        return this.serverAddress;
    }

    @Override
    public String[] getQueries() {
        return this.queries;
    }

    @Override
    public int hashCode() {
        return this.pointcutProperties.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return false;
    }
}

