/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.db;

import com.manageengine.apminsight.agent.JavaAgent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PreparedQueryExtractor {
    static Map<String, Object> keyAttributes = new ConcurrentHashMap<String, Object>(4, 0.75f, 2);
    static final Object[] ZERO_OBJ_ARGS = new Object[0];
    static final Object DUMMY = new Object();

    public static String getPreparedQueryByReflection(Object prepStmt) {
        String prepStmtClassName = prepStmt.getClass().getName();
        Object obj = keyAttributes.get(prepStmtClassName);
        if (obj != null) {
            return PreparedQueryExtractor.getQueryUsingCachedAttr(obj, prepStmt);
        }
        return PreparedQueryExtractor.tryGetQuery(prepStmtClassName, prepStmt);
    }

    private static String getQueryUsingCachedAttr(Object attr, Object thiz) {
        try {
            if (attr == DUMMY) {
                return null;
            }
            if (attr instanceof Method) {
                return ((Method)attr).invoke(thiz, ZERO_OBJ_ARGS).toString();
            }
            return ((Field)attr).get(thiz).toString();
        }
        catch (Throwable th) {
            JavaAgent.logger.warn(th.getMessage());
            return null;
        }
    }

    private static String tryGetQuery(String prepStmtClassName, Object prepStmt) {
        String query = null;
        Object attribute = null;
        try {
            if (prepStmtClassName.contains(".mysql.")) {
                Class<?> statementClass = prepStmt.getClass().getClassLoader().loadClass("com.mysql.jdbc.PreparedStatement");
                if (!statementClass.isInstance(prepStmt)) {
                    Field sqlField = statementClass.getDeclaredField("originalSql");
                    sqlField.setAccessible(true);
                    query = (String)sqlField.get(prepStmt);
                    attribute = sqlField;
                } else {
                    try {
                        Method asSql = statementClass.getDeclaredMethod("asSql", new Class[0]);
                        asSql.setAccessible(true);
                        query = (String)asSql.invoke(prepStmt, ZERO_OBJ_ARGS);
                        attribute = asSql;
                    }
                    catch (NoSuchMethodException e) {
                        Field sqlField = statementClass.getDeclaredField("originalSql");
                        sqlField.setAccessible(true);
                        query = (String)sqlField.get(prepStmt);
                        attribute = sqlField;
                    }
                }
            } else if (prepStmtClassName.contains("as400")) {
                Field sqlStatement = prepStmt.getClass().getDeclaredField("sqlStatement_");
                sqlStatement.setAccessible(true);
                query = sqlStatement.get(prepStmt).toString();
                attribute = sqlStatement;
            } else if (prepStmtClassName.contains("jtds") || prepStmtClassName.contains(".ibm.")) {
                Field declrdField = prepStmt.getClass().getDeclaredField("sql");
                declrdField.setAccessible(true);
                query = (String)declrdField.get(prepStmt);
                attribute = declrdField;
            } else if (prepStmtClassName.contains("oracle")) {
                try {
                    Method meth = prepStmt.getClass().getMethod("getOriginalSql", new Class[0]);
                    meth.setAccessible(true);
                    query = (String)meth.invoke(prepStmt, ZERO_OBJ_ARGS);
                    attribute = meth;
                }
                catch (Throwable th) {
                    Method meth = prepStmt.getClass().getDeclaredMethod("getOriginalSql", new Class[0]);
                    meth.setAccessible(true);
                    query = (String)meth.invoke(prepStmt, ZERO_OBJ_ARGS);
                    attribute = meth;
                }
            } else if (prepStmtClassName.contains("microsoft")) {
                Field field = prepStmt.getClass().getDeclaredField("preparedSQL");
                field.setAccessible(true);
                query = (String)field.get(prepStmt);
                attribute = field;
            }
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("Prep.Query extraction by reflection failed. Excep. " + th.getMessage() + " Clz: " + prepStmtClassName);
            attribute = DUMMY;
        }
        if (attribute == null) {
            JavaAgent.logger.warn("Prep.Query extraction by reflection failed. attribute=null. Clz: " + prepStmtClassName);
            attribute = DUMMY;
        }
        keyAttributes.put(prepStmtClassName, attribute);
        return query;
    }
}

