/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.db;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.logging.AgentLogger;
import com.manageengine.apminsight.agent.util.ConcurrentWeakDictionary;
import com.manageengine.org.apache.logging.log4j.Level;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class QueryHolder {
    private static final ConcurrentWeakDictionary<Object, String> PREPARED_QUERY_STORE = new ConcurrentWeakDictionary(30, 0.75f, 3);
    private Map<Object, List<String>> stmtVsBatchQueries = new LinkedHashMap<Object, List<String>>();
    private static AgentLogger logger = JavaAgent.logger;

    public void addBatchQuery(Object statement, String batchQuery) {
        List<String> batchQueries = this.stmtVsBatchQueries.get(statement);
        if (batchQueries == null) {
            batchQueries = new ArrayList<String>();
            batchQueries.add(batchQuery);
            this.stmtVsBatchQueries.put(statement, batchQueries);
        } else {
            batchQueries.add(batchQuery);
        }
        if (logger.isLoggable(Level.DEBUG)) {
            logger.debug("batchQuery: {} added to the statement: {} Total queries: {} Total Statements in cache: {}", batchQuery, System.identityHashCode(statement), batchQueries.size(), this.stmtVsBatchQueries.size());
        }
    }

    public List<String> removeBatchQueries(Object statement) {
        List<String> batchQueries = this.stmtVsBatchQueries.remove(statement);
        if (batchQueries != null && logger.isLoggable(Level.DEBUG)) {
            logger.debug("Statement: {} with batchQueries: {} removed. Total Statements in cache: {}", System.identityHashCode(statement), batchQueries.size(), this.stmtVsBatchQueries.size());
        }
        return batchQueries;
    }

    public List<String> getBatchQueries(Object statement) {
        return this.stmtVsBatchQueries.get(statement);
    }

    public static void setPreparedQuery(Object prepStatement, String prepQuery) {
        PREPARED_QUERY_STORE.putIfNotExists(prepStatement, prepQuery);
    }

    public static String getPreparedQuery(Object prepStatement) {
        return PREPARED_QUERY_STORE.get(prepStatement);
    }

    public static String removePreparedQuery(Object prepStatement) {
        return PREPARED_QUERY_STORE.remove(prepStatement);
    }

    public static int getOccupiedSize() {
        return PREPARED_QUERY_STORE.size();
    }
}

