/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.db;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.trackers.db.QueryInfo;
import com.manageengine.org.apache.logging.log4j.Level;
import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum QueryParser {
    DML("^(\\s|\\t|\\n)*(select|delete).*\\s+(from)\\s+([^\\s,(;]*).*"){

        @Override
        protected QueryInfo createQueryInfo(Matcher m) {
            return new QueryInfo(m.group(), m.group(2), m.group(4));
        }
    }
    ,
    DML_INSERT("^(\\s|\\t|\\n)*(insert)\\s+(into)\\s+([^\\s,(;]*).*"){

        @Override
        protected QueryInfo createQueryInfo(Matcher m) {
            return new QueryInfo(m.group(), m.group(2), m.group(4));
        }
    }
    ,
    DML_UPDATE("^(\\s|\\t|\\n)*(update)\\s+([^\\s,(;]*).*"){

        @Override
        protected QueryInfo createQueryInfo(Matcher m) {
            return new QueryInfo(m.group(), m.group(2), m.group(3));
        }
    }
    ,
    DDL("^(\\s|\\t|\\n)*(create|drop)\\s+(procedure|database|table).*"){

        @Override
        protected QueryInfo createQueryInfo(Matcher m) {
            return new QueryInfo(m.group(), m.group(2), m.group(3));
        }
    }
    ,
    ALTER("^(\\s|\\t|\\n)*(alter)\\s+([^\\s]*).*"){

        @Override
        protected QueryInfo createQueryInfo(Matcher m) {
            return new QueryInfo(m.group(), m.group(2), m.group(3));
        }
    }
    ,
    DML_PROC("^(\\s|\\t|\\n)*(call|execute)\\s+([^\\s(,]*).*"){

        @Override
        protected QueryInfo createQueryInfo(Matcher m) {
            return new QueryInfo(m.group(), m.group(2), m.group(3));
        }
    };

    private final Pattern p;

    private QueryParser(String pattern) {
        this.p = Pattern.compile(pattern, 34);
    }

    protected QueryInfo createQueryInfo(Matcher m) {
        return null;
    }

    private Pattern getQueryPattern() {
        return this.p;
    }

    public static QueryInfo getQueryInfo(String sql) {
        for (QueryParser qP : EnumSet.allOf(QueryParser.class)) {
            Matcher m = qP.getQueryPattern().matcher(sql);
            if (!m.find()) continue;
            return qP.createQueryInfo(m);
        }
        JavaAgent.logger.log(Level.TRACE, "SQL: {}", (Object)sql);
        return null;
    }

    public static String standardizeQuery(String query, boolean shouldRemoveQueryLiterals) {
        query = query.replaceAll("(\\t|\\n)+", " ");
        query = query.replaceAll("\\,", ", ");
        query = query.replaceAll("\\s+", " ");
        query = query.replaceAll("/\\*.+\\*/", "");
        if (shouldRemoveQueryLiterals) {
            return QueryParser.splitQuerybyIdentifier(query);
        }
        return query;
    }

    private static String splitQuerybyIdentifier(String standardizedQuery) {
        String splitted_joined_query = "";
        String lowercasedQuery = standardizedQuery.toLowerCase();
        int split_index = -1;
        if (lowercasedQuery.contains("insert into")) {
            split_index = lowercasedQuery.indexOf(" values");
        } else if (lowercasedQuery.contains("select ") || lowercasedQuery.contains("delete ")) {
            split_index = lowercasedQuery.indexOf(" where ");
        } else if (lowercasedQuery.contains("update ")) {
            split_index = lowercasedQuery.indexOf(" set ");
        } else if (lowercasedQuery.contains("create table ") || lowercasedQuery.contains("drop table ") || lowercasedQuery.contains("alter table ")) {
            standardizedQuery = standardizedQuery.replaceAll("[`\"]", "");
        }
        if (split_index > -1) {
            splitted_joined_query = standardizedQuery.substring(0, split_index).replaceAll("[`\"]", "") + standardizedQuery.substring(split_index, standardizedQuery.length());
            return splitted_joined_query;
        }
        return standardizedQuery;
    }

    public static void main(String[] args) {
        QueryInfo qi = QueryParser.getQueryInfo("call  DTSTAP_L04(?,?)");
    }
}

