/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.db;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.config.JavaAgentConfig;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.parser.StatementParser;
import com.manageengine.apminsight.agent.sequence.SequenceSpace;
import com.manageengine.apminsight.agent.trackers.RootTracker;
import com.manageengine.apminsight.agent.trackers.db.AbstractDBTracker;
import com.manageengine.apminsight.agent.trackers.db.PreparedQueryExtractor;
import com.manageengine.apminsight.agent.trackers.db.QueryHolder;
import com.manageengine.org.apache.logging.log4j.Level;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;

public class StatementTracker
extends AbstractDBTracker {
    protected Object[] args;
    protected Object statement;

    public StatementTracker(PointcutProperties pointcutProperties, Object thiz, Object[] args, boolean isPreparedStatement) {
        super(pointcutProperties, thiz, args);
        this.isLeafTracker = false;
        this.args = args;
        if ("executeBatch".equals(pointcutProperties.getInterceptedMethodName())) {
            this.queries = this.getBatchAddedSQLs(thiz, isPreparedStatement);
            this.startTime = System.currentTimeMillis();
        } else if (isPreparedStatement) {
            this.statement = thiz;
        }
        if (JavaAgentConfig.captureHostDetails) {
            this.serverAddress = StatementParser.getAddress(thiz);
        }
    }

    @Override
    public void quit(int opcode, Object rv) {
        super.quit(opcode, rv);
        if (rv instanceof Integer) {
            this.rowsCount = (Integer)rv;
        } else if (this.rowsCount == -1) {
            this.rowsCount = this.getRowsFetched(rv);
        }
    }

    private int getRowsFetched(Object rv) {
        int rowsFetched = -1;
        try {
            Class<?> clz = rv.getClass();
            String clzName = clz.getName();
            if (clzName.contains("mysql")) {
                Method m = clz.getMethod("getUpdateCount", new Class[0]);
                rowsFetched = Integer.parseInt(m.invoke(rv, new Object[0]).toString());
                rowsFetched = rowsFetched == -1 ? 1 : rowsFetched;
            } else if (clzName.contains("microsoft")) {
                Field f = clz.getDeclaredField("numFetchedRows");
                f.setAccessible(true);
                rowsFetched = (Integer)f.get(rv);
            } else if (clzName.contains("yugabyte")) {
                Field f = clz.getDeclaredField("rows");
                f.setAccessible(true);
                rowsFetched = ((List)f.get(rv)).size();
            }
        }
        catch (Exception e) {
            JavaAgent.logger.debug("Unable to get rows fetched using reflection." + e.getMessage());
        }
        return rowsFetched;
    }

    @Override
    protected void quit() {
        super.quit();
        if (!"executeBatch".equals(this.pointcutProperties.getInterceptedMethodName())) {
            if (this.statement != null) {
                try {
                    String className = this.statement.getClass().getName();
                    String sql = null;
                    if (className.contains("mysql")) {
                        sql = this.statement.toString();
                        String[] s = sql.split(": |] - ");
                        sql = sql.length() > 1 ? s[1] : s[0];
                    } else {
                        sql = className.contains("postgresql") || className.contains("yugabyte") ? this.statement.toString() : this.getPreparedQuery(this.statement);
                    }
                    if (sql != null) {
                        this.queries = new String[]{sql};
                    }
                }
                catch (Exception e) {
                    JavaAgent.logger.log(Level.WARN, "Unable to fetch query for pointcut: " + this.pointcutProperties.toString(), e);
                }
            } else if (this.args != null && this.args[0] != null) {
                this.queries = new String[]{(String)this.args[0]};
            } else {
                JavaAgent.logger.warn("args holds no query in call " + this.pointcutProperties.getInterceptedClassName() + "." + this.pointcutProperties.getInterceptedMethodName() + "()");
            }
        }
        this.standardizeQueries();
        this.statement = null;
        this.args = null;
    }

    protected String[] getBatchAddedSQLs(Object statement, boolean isPreparedStatement) {
        if (isPreparedStatement) {
            String query = QueryHolder.removePreparedQuery(statement);
            if (query != null) {
                List<?> batchedItems = this.getBatchedItemListbyReflection(statement);
                if (batchedItems != null) {
                    this.batchQueriesCount = batchedItems.size();
                }
                return new String[]{query};
            }
            return null;
        }
        List<String> batchQueries = SequenceSpace.SEQUENCE_BOOK.get().getQueryHolder().removeBatchQueries(statement);
        if (batchQueries == null) {
            JavaAgent.logger.debug("Attempt to get batchQueries from cache failed. Attempting reflection.");
            List<?> batchedItems = this.getBatchedItemListbyReflection(statement);
            if (batchedItems != null) {
                this.batchQueriesCount = batchedItems.size();
            }
            return this.getBatchAddedSQLs(statement, isPreparedStatement, batchedItems);
        }
        this.batchQueriesCount = batchQueries.size();
        return batchQueries.toArray(new String[batchQueries.size()]);
    }

    protected String[] getBatchAddedSQLs(Object statement, boolean isPreparedStatement, List<?> batchedArgs) {
        if (batchedArgs != null) {
            String[] batchedSQLs = new String[batchedArgs.size()];
            int i = 0;
            for (Object batchedQuery : batchedArgs) {
                if (batchedQuery == null) continue;
                batchedSQLs[i++] = batchedQuery.toString();
            }
            if (batchedArgs.size() != i) {
                String[] batchdSQLs = new String[i];
                System.arraycopy(batchedSQLs, 0, batchdSQLs, 0, i);
                batchedSQLs = batchdSQLs;
            }
            return batchedSQLs;
        }
        if (statement.getClass().getName().contains("postgresql") || statement.getClass().getName().contains("yugabyte")) {
            String[] q = new String[]{statement.toString()};
            return q;
        }
        RootTracker rt = SequenceSpace.SEQUENCE_BOOK.get().getRootTracker();
        JavaAgent.logger.log(Level.WARN, "Attempt to extract batch queries failed for Statement: {} Web-Transaction: {}", statement.getClass().getName(), rt != null ? rt.getSequenceNameSpace() : " rootTracker is null");
        return null;
    }

    private List<?> getBatchedItemListbyReflection(Object statement) {
        Class<?> clz = statement.getClass();
        String className = clz.getName();
        String fieldStr = null;
        List batchedArgs = null;
        Field field = null;
        try {
            fieldStr = "batchedArgs";
            if (className.contains("mysql")) {
                fieldStr = "batchedArgs";
            } else if (className.contains("postgresql") || className.contains("yugabyte")) {
                fieldStr = "batchStatements";
            } else if (className.contains("jtds")) {
                fieldStr = "batchValues";
            } else if (className.contains("oracle")) {
                fieldStr = "m_batchItems";
            } else if (className.contains("ibm")) {
                fieldStr = "batchValues";
            } else if (className.contains("SQLServer")) {
                fieldStr = "batchParamValues";
            }
            try {
                field = clz.getDeclaredField(fieldStr);
            }
            catch (NoSuchFieldException n) {
                try {
                    field = clz.getSuperclass().getDeclaredField(fieldStr);
                }
                catch (NoSuchFieldException n1) {
                    field = clz.getSuperclass().getSuperclass().getDeclaredField(fieldStr);
                }
            }
            field.setAccessible(true);
            batchedArgs = (List)field.get(statement);
        }
        catch (Exception e) {
            JavaAgent.logger.warn("Unable to get batchedItemsList for statementObj of class : " + statement.getClass().getName());
        }
        return batchedArgs;
    }

    private String getPreparedQuery(Object prepStmt) {
        String query = QueryHolder.getPreparedQuery(prepStmt);
        if (query == null) {
            boolean attemptByReflection = JavaAgent.getInstance().agentConfig.canCaptureSqlByReflection();
            JavaAgent.logger.debug("PreparedQuery not found in PreparedQueryStore. Attempt by reflection: " + attemptByReflection);
            if (attemptByReflection) {
                query = PreparedQueryExtractor.getPreparedQueryByReflection(prepStmt);
            }
        }
        return query;
    }

    public void setRowsFetchedCount(int n) {
        this.rowsCount = n;
    }
}

