/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.db.r2dbc;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.config.JavaAgentConfig;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.trackers.db.AbstractDBTracker;
import com.manageengine.apminsight.agent.util.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class R2DBCMsSqlTracker
extends AbstractDBTracker {
    protected Object statement;

    public R2DBCMsSqlTracker(PointcutProperties pointcutProperties, Object thiz, Object[] args, boolean isPreparedStatement) {
        super(pointcutProperties, thiz, args);
        this.isLeafTracker = false;
        this.statement = thiz;
        if (JavaAgentConfig.captureHostDetails) {
            this.serverAddress = this.getAddress(this.statement);
        }
        this.queries = this.getQueries(this.statement);
    }

    private String[] getQueries(Object statement) {
        if (JavaAgent.getInstance().agentConfig.canCaptureSqlByReflection()) {
            String sql = "";
            String statementClassName = statement.getClass().getName();
            try {
                if (statementClassName.endsWith("SimpleMssqlStatement")) {
                    Field f = statement.getClass().getField("sql");
                    f.setAccessible(true);
                    sql = (String)f.get(statement);
                } else if (statementClassName.endsWith("ParametrizedMssqlStatement")) {
                    Field f = statement.getClass().getField("parsedQuery");
                    f.setAccessible(true);
                    Object o = f.get(statement);
                    Method m = o.getClass().getMethod("getSql", new Class[0]);
                    sql = (String)m.invoke(o, new Object[0]);
                }
                if (!StringUtils.isEmptyString(sql)) {
                    return new String[]{sql};
                }
            }
            catch (Exception e) {
                JavaAgent.logger.warn("Exception occured while fetching SQL from " + statement.getClass().getSimpleName() + " object: " + e.getMessage());
            }
        }
        return null;
    }

    private String getAddress(Object statement) {
        return null;
    }
}

