/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.elasticsearch;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.metrics.ComponentMetric;
import com.manageengine.apminsight.agent.metrics.MetricData;
import com.manageengine.apminsight.agent.sequence.SequenceHeader;
import com.manageengine.apminsight.agent.sequence.SequenceSpace;
import com.manageengine.apminsight.agent.trackers.DefaultTracker;
import com.manageengine.apminsight.agent.trackers.external.IExternalTracker;
import com.manageengine.apminsight.agent.util.InetAddressUtil;
import com.manageengine.apminsight.agent.util.StringUtils;
import com.manageengine.org.apache.logging.log4j.Level;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

public class ElasticSearchTransportClientTracker
extends DefaultTracker
implements IExternalTracker {
    private String operation;
    private String serverAddress;
    private StringBuilder index_type;
    private Object[] args;

    public ElasticSearchTransportClientTracker(PointcutProperties pointcutProperties, Object thiz, Object[] args) {
        super(pointcutProperties, thiz, args);
        this.isLeafTracker = true;
        this.args = args;
    }

    @Override
    protected void quit() {
        super.quit();
        try {
            Object[] obj;
            this.operation = (String)this.args[0].getClass().getMethod("name", new Class[0]).invoke(this.args[0], new Object[0]);
            Class<?> requestClz = this.args[1].getClass();
            this.index_type = new StringBuilder();
            try {
                this.index_type.append((String)requestClz.getMethod("index", new Class[0]).invoke(this.args[1], new Object[0]));
            }
            catch (NoSuchMethodException e) {
                obj = (Object[])requestClz.getMethod("indices", new Class[0]).invoke(this.args[1], new Object[0]);
                this.index_type.append(Arrays.deepToString(obj));
            }
            this.index_type.append(" / ");
            try {
                this.index_type.append((String)requestClz.getMethod("type", new Class[0]).invoke(this.args[1], new Object[0]));
            }
            catch (NoSuchMethodException e) {
                obj = (Object[])requestClz.getMethod("types", new Class[0]).invoke(this.args[1], new Object[0]);
                this.index_type.append(Arrays.deepToString(obj));
            }
        }
        catch (Exception e) {
            JavaAgent.logger.log(Level.WARN, "[ElasticSearchTransportClientTracker] Unable to extract query info for Elasticsearch call. Exception: " + e.getMessage());
        }
        this.checkForErrorAndGetAddress(this.args[2]);
        this.args = null;
    }

    private void checkForErrorAndGetAddress(Object listener) {
        try {
            Method m = listener.getClass().getMethod("actionGet", new Class[0]);
            Object response = m.invoke(listener, new Object[0]);
            this.serverAddress = response.getClass().getMethod("remoteAddress", new Class[0]).invoke(response, new Object[0]).toString();
        }
        catch (InvocationTargetException ex) {
            this.error = ex.getTargetException();
            SequenceSpace.SEQUENCE_BOOK.get().markSequenceAsErr(this.error);
        }
        catch (Throwable th) {
            JavaAgent.logger.log(Level.WARN, "Exception occurred while checking status of Elasticsearch call. ", th);
        }
    }

    @Override
    public boolean generateMetric(SequenceHeader seqHeader, int childDuration, MetricData metricData) {
        this.operation = this.operation.substring(this.operation.lastIndexOf(47) + 1);
        this.serverAddress = InetAddressUtil.standardizeServerAddress(this.serverAddress);
        ((ComponentMetric)metricData).recordComponentData(this.pointcutProperties.getComponent(), this.serverAddress, this.duration - childDuration, this.isErroneous());
        return true;
    }

    @Override
    public String getTrackerSignature() {
        StringBuilder signature = new StringBuilder();
        signature.append(this.pointcutProperties.getComponent().toString());
        signature.append(" - ");
        signature.append(this.operation.toUpperCase());
        if (this.index_type != null) {
            signature.append(" - ");
            signature.append(this.index_type.toString());
        }
        if (!StringUtils.isEmptyString(this.serverAddress)) {
            signature.append(" - ");
            try {
                signature.append(this.serverAddress.split("/")[1]);
            }
            catch (Exception e) {
                signature.append(this.serverAddress);
            }
        }
        if (this.isErroneous()) {
            signature.append(" Error: ");
            signature.append(this.error.getClass().getSimpleName());
        }
        return signature.toString();
    }

    @Override
    public String getServerAddress() {
        return this.serverAddress;
    }
}

