/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.grpc;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.BasicPointcutProperties;
import com.manageengine.apminsight.agent.sequence.HandHoldingSpace;
import com.manageengine.apminsight.agent.trackers.DefaultTracker;
import com.manageengine.apminsight.agent.trackers.VoidTracker;
import com.manageengine.apminsight.agent.trackers.grpc.GrpcClientCall;
import java.lang.reflect.Method;

public class GrpcChannelTracker
extends DefaultTracker
implements VoidTracker {
    private GrpcClientCall clientCall;

    public GrpcChannelTracker(BasicPointcutProperties pointcut, Object thisObj, Object[] args) {
        super(pointcut, thisObj, args);
        this.constructClientCall(thisObj, args);
    }

    private void constructClientCall(Object thisObj, Object[] args) {
        try {
            Object methodDescriptor = args[0];
            Method m = methodDescriptor.getClass().getMethod("getFullMethodName", new Class[0]);
            String fullMethodName = String.valueOf(m.invoke(methodDescriptor, new Object[0]));
            this.clientCall = new GrpcClientCall(fullMethodName);
            m = methodDescriptor.getClass().getMethod("getType", new Class[0]);
            String methodType = ((Enum)m.invoke(methodDescriptor, new Object[0])).name();
            this.clientCall.setRequestType(methodType);
            m = thisObj.getClass().getMethod("authority", new Class[0]);
            m.setAccessible(true);
            String target = String.valueOf(m.invoke(thisObj, new Object[0]));
            this.clientCall.setTarget(target);
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("Unable to construct grpc client call. Exception: ", th.getMessage());
        }
    }

    @Override
    public void quit(int opcode, Object returnValue) {
        if (returnValue != null && this.clientCall != null) {
            HandHoldingSpace.SPACE.get().storeWithID(returnValue, this.clientCall);
        }
    }
}

