/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.grpc;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.metrics.ComponentMetric;
import com.manageengine.apminsight.agent.metrics.MetricData;
import com.manageengine.apminsight.agent.sequence.HandHoldingSpace;
import com.manageengine.apminsight.agent.sequence.SequenceHeader;
import com.manageengine.apminsight.agent.sequence.SequenceSpace;
import com.manageengine.apminsight.agent.trackers.CallerAsyncRootTracker;
import com.manageengine.apminsight.agent.trackers.grpc.GrpcClientCall;
import com.manageengine.apminsight.agent.trackers.grpc.GrpcMetadataHandler;
import com.manageengine.apminsight.agent.trackers.httpclient.HttpClientTrackerUtil;
import com.manageengine.apminsight.agent.trackers.httpclient.IHttpClientTracker;
import com.manageengine.apminsight.agent.util.InetAddressUtil;
import com.manageengine.org.json.simple.JSONValue;
import java.util.Map;

public class GrpcClientCallTracker
extends CallerAsyncRootTracker
implements IHttpClientTracker {
    private GrpcClientCall clientCall;
    private String serverAddress;

    public GrpcClientCallTracker(PointcutProperties pointcut, Object thizObj, Object[] args) {
        super(pointcut, null, null);
        this.isLeafTracker = true;
        this.setCallbackObj(args[0]);
        this.setDTHeaderInRequest(args[1]);
        this.clientCall = (GrpcClientCall)HandHoldingSpace.SPACE.get().getObjectWithID(thizObj);
    }

    @Override
    public void setDTHeaderInRequest(Object metadata) {
        try {
            if (SequenceSpace.SEQUENCE_BOOK.get().getConfig().isDistributedTracingEnabled()) {
                GrpcMetadataHandler.putHeader(metadata, "X-Site24x7-Id", JavaAgent.getInstance().agentConfig.getDistributedTracingId());
            }
        }
        catch (Throwable th) {
            JavaAgent.logger.debug("Unable to set DT Header for grpc client call. Exception:" + th.getLocalizedMessage());
        }
    }

    @Override
    public String getDTHeaderFromResponse(Object metadata) {
        try {
            String dtData = GrpcMetadataHandler.getHeader(metadata, "X-Site24x7-DT-Data");
            this.clientCall.setDtData(dtData);
            return dtData;
        }
        catch (Throwable th) {
            JavaAgent.logger.debug("Unable to get DT Header for grpc client call. Exception:" + th.getLocalizedMessage());
            return null;
        }
    }

    public void setStatus(Object status) {
        try {
            Throwable th = (Throwable)status.getClass().getMethod("getCause", new Class[0]).invoke(status, new Object[0]);
            if (th != null) {
                this.markFailed(th);
            } else {
                this.markCompleted(null);
            }
            String code = ((Enum)status.getClass().getMethod("getCode", new Class[0]).invoke(status, new Object[0])).name();
            this.clientCall.setStatus(code);
        }
        catch (Throwable th) {
            JavaAgent.logger.debug("Unable to get status of grpc client call. Exception: ", th.getLocalizedMessage());
        }
    }

    @Override
    public boolean generateMetric(SequenceHeader seqHeader, int childDuration, MetricData metricData) {
        if (this.clientCall != null) {
            ((ComponentMetric)metricData).recordComponentData(this.pointcutProperties.getComponent(), this.getServerAddress(), HttpClientTrackerUtil.extractInstanceIdFromDtData(this.clientCall.getDtData()), this.duration - childDuration, this.isErroneous());
        } else {
            ((ComponentMetric)metricData).recordComponentData(this.pointcutProperties.getComponent(), this.duration - childDuration, this.isErroneous());
        }
        return true;
    }

    @Override
    public String getTrackerSignature() {
        return this.clientCall == null ? this.pointcutProperties.getSignature() : this.clientCall.toString();
    }

    @Override
    public Map<String, Object> getMoreData(Map<String, Object> moreData) {
        if (this.clientCall != null && this.clientCall.getDtData() != null) {
            Map data = (Map)JSONValue.parse(this.clientCall.getDtData());
            moreData.put("dtdata", data);
        }
        return moreData;
    }

    @Override
    public String getServerAddress() {
        if (this.serverAddress == null) {
            this.serverAddress = InetAddressUtil.standardizeServerAddress(this.clientCall.getTarget());
        }
        return this.serverAddress;
    }

    @Override
    public String getRequestUrl(Object requestObject) {
        return this.clientCall.getEndpoint();
    }

    @Override
    public String getHttpMethod(Object requestObject) {
        return this.clientCall.getRequestType();
    }

    @Override
    public int getStatusCode(Object respObj) {
        return -1;
    }

    @Override
    public boolean isDTCall() {
        return this.clientCall != null && this.clientCall.isDTCall();
    }

    @Override
    public Map<String, String> getDTdata() {
        if (this.clientCall != null && this.clientCall.getDtData() != null) {
            return (Map)JSONValue.parse(this.clientCall.getDtData());
        }
        return null;
    }
}

