/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.grpc;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class GrpcMetadataHandler {
    private static Class<?> keyClz = null;
    private static Map<String, Object> keyMap = new HashMap<String, Object>();

    public static Object getKeyObject(Object metadata, String headerName) {
        Object key = keyMap.get(headerName);
        if (key == null) {
            try {
                Class<?> metadataClz = metadata.getClass();
                keyClz = Class.forName("io.grpc.Metadata$Key", false, metadataClz.getClassLoader());
                Class<?> marshallerClz = Class.forName("io.grpc.Metadata$AsciiMarshaller", false, metadataClz.getClassLoader());
                Field f = metadataClz.getField("ASCII_STRING_MARSHALLER");
                Object marshaller = f.get(null);
                Method m = keyClz.getMethod("of", String.class, marshallerClz);
                key = m.invoke(null, headerName, marshaller);
                keyMap.put(headerName, key);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return key;
    }

    private static void setKeyClz(ClassLoader clzLoader) {
        try {
            keyClz = Class.forName("io.grpc.Metadata$Key", false, clzLoader);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void putHeader(Object metadata, String key, String value) throws Throwable {
        if (keyClz == null) {
            GrpcMetadataHandler.setKeyClz(metadata.getClass().getClassLoader());
        }
        Method m = metadata.getClass().getMethod("put", keyClz, Object.class);
        m.invoke(metadata, GrpcMetadataHandler.getKeyObject(metadata, key), value);
    }

    public static String getHeader(Object metadata, String key) throws Throwable {
        if (keyClz == null) {
            GrpcMetadataHandler.setKeyClz(metadata.getClass().getClassLoader());
        }
        Method m = metadata.getClass().getMethod("get", keyClz);
        return (String)m.invoke(metadata, GrpcMetadataHandler.getKeyObject(metadata, key));
    }

    public static boolean containsHeader(Object metadata, String key) {
        try {
            if (keyClz == null) {
                GrpcMetadataHandler.setKeyClz(metadata.getClass().getClassLoader());
            }
            Method m = metadata.getClass().getMethod("containsKey", keyClz);
            return (Boolean)m.invoke(metadata, GrpcMetadataHandler.getKeyObject(metadata, key));
        }
        catch (Throwable th) {
            return false;
        }
    }
}

