/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.grpc;

import com.manageengine.apminsight.agent.context.ContextInfo;
import com.manageengine.apminsight.agent.context.ContextInfoManager;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.trackers.background.BackgroundSeqRootTracker;
import com.manageengine.apminsight.agent.trackers.grpc.GrpcMetadataHandler;
import com.manageengine.apminsight.agent.trackers.grpc.GrpcServerCall;
import com.manageengine.org.json.simple.JSONObject;
import java.util.HashMap;

public class GrpcServerCallTracker
extends BackgroundSeqRootTracker {
    private GrpcServerCall serverCall;

    public GrpcServerCallTracker(PointcutProperties pointcutProperties, GrpcServerCall serverCall) {
        super(pointcutProperties, null, null);
        this.serverCall = serverCall;
    }

    @Override
    protected String assignSequenceName() {
        this.seqName = this.serverCall != null ? this.serverCall.getEndpoint() : super.assignSequenceName();
        this.hasMetric = true;
        return this.seqName;
    }

    public void setStatus(Object status) {
        try {
            String code = ((Enum)status.getClass().getMethod("getCode", new Class[0]).invoke(status, new Object[0])).name();
            this.serverCall.setStatus(code);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public GrpcServerCall getServerCall() {
        return this.serverCall;
    }

    public boolean isDTHeaderPresent() {
        return this.serverCall.isDtHeaderPresent();
    }

    public void setResponseHeader(Object metadata) {
        try {
            ContextInfo context = ContextInfoManager.getInstance().getDefaultContextInfo();
            if (context != null && context.isActive() && context.getConfig().isDistributedTracingEnabled()) {
                HashMap<String, Object> dtData = new HashMap<String, Object>();
                dtData.put("s_time", this.getStartTime());
                dtData.put("t_name", this.getSequenceNameSpace());
                dtData.put("instance_id", context.getInstanceID());
                GrpcMetadataHandler.putHeader(metadata, "X-Site24x7-DT-Data", JSONObject.toJSONString(dtData));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public String getTrackerSignature() {
        if (this.serverCall != null) {
            return this.serverCall.toString();
        }
        return super.getTrackerSignature();
    }
}

