/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.grpc;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.sequence.HandHoldingSpace;
import com.manageengine.apminsight.agent.trackers.DefaultTracker;
import com.manageengine.apminsight.agent.trackers.VoidTracker;
import com.manageengine.apminsight.agent.trackers.grpc.GrpcServerCall;
import com.manageengine.apminsight.agent.trackers.grpc.GrpcServerCallTracker;
import java.lang.reflect.Method;

public class GrpcServerTracker
extends DefaultTracker
implements VoidTracker {
    private GrpcServerCallTracker serverCallTracker;

    public GrpcServerTracker(PointcutProperties pointcut, Object thiz, Object[] args) {
        super(pointcut, thiz, args);
        GrpcServerCall serverCall = new GrpcServerCall();
        this.serverCallTracker = new GrpcServerCallTracker(pointcut, serverCall);
        try {
            Object serverMethodDefinition = args[1] instanceof String ? args[2] : args[1];
            Method m = serverMethodDefinition.getClass().getMethod("getMethodDescriptor", new Class[0]);
            Object methodDefinition = m.invoke(serverMethodDefinition, new Object[0]);
            if (args[1] instanceof String) {
                serverCall.setEndpoint((String)args[1]);
            } else {
                m = methodDefinition.getClass().getMethod("getFullMethodName", new Class[0]);
                String endpoint = (String)m.invoke(methodDefinition, new Object[0]);
                serverCall.setEndpoint(endpoint);
                HandHoldingSpace.SPACE.get().storeWithID(endpoint, this);
            }
            m = methodDefinition.getClass().getMethod("getType", new Class[0]);
            String methodType = ((Enum)m.invoke(methodDefinition, new Object[0])).name();
            serverCall.setRequestType(methodType);
        }
        catch (Throwable th) {
            JavaAgent.logger.debug("Unable to get additional info for grpc server call. Exception: " + th.getLocalizedMessage());
        }
        HandHoldingSpace.SPACE.get().storeUntilConsumed(args[0], this.serverCallTracker);
    }

    @Override
    public void quit(int opcode, Object returnValue) {
        super.quit(opcode, returnValue);
        HandHoldingSpace.SPACE.get().storeWithID(returnValue, this.serverCallTracker);
    }

    public GrpcServerCall getServerCall() {
        return this.serverCallTracker.getServerCall();
    }
}

