/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.http;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.context.ContextInfoManager;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.metrics.ApdexMetric;
import com.manageengine.apminsight.agent.metrics.ComponentMetric;
import com.manageengine.apminsight.agent.metrics.HTTPMetric;
import com.manageengine.apminsight.agent.metrics.MetricData;
import com.manageengine.apminsight.agent.sequence.SequenceHeader;
import com.manageengine.apminsight.agent.trackers.WebSeqRootTracker;
import com.manageengine.apminsight.agent.util.SequenceURINormalizer;
import com.manageengine.apminsight.agent.util.StringUtils;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;

public class IntegrationServerTracker
extends WebSeqRootTracker {
    private String queryString;
    private int httpCode;
    private Object httpStateObj;

    public IntegrationServerTracker(PointcutProperties pointcutProperties, Object gState) {
        super(pointcutProperties, gState, null);
        this.getHttpInfo(gState);
        this.httpStateObj = gState;
    }

    private void getHttpInfo(Object gState) {
        try {
            Class<?> clz = gState.getClass();
            Method m = clz.getMethod("getHttpRequestUrl", new Class[0]);
            this.unnormalizedSeqName = (String)m.invoke(gState, new Object[0]);
            this.unnormalizedSeqName = this.unnormalizedSeqName.equals("") ? "/" : this.unnormalizedSeqName;
            m = clz.getMethod("getRequestTypeAsString", new Class[0]);
            this.httpMethod = (String)m.invoke(gState, new Object[0]);
            if (ContextInfoManager.getInstance().getContextInfoOrDefault(this.getContextPath()).getConfig().getWebSeqConfig().isRecordSequenceTraceInputParams()) {
                m = clz.getMethod("getHttpRequestUrlQuery", new Class[0]);
                this.queryString = (String)m.invoke(gState, new Object[0]);
            }
        }
        catch (Exception e) {
            JavaAgent.logger.warn("[IServer] Unable to get http info. " + e.getMessage());
        }
    }

    @Override
    protected String assignSequenceName() {
        this.seqName = StringUtils.isEmptyString(this.unnormalizedSeqName) ? "unknown" : SequenceURINormalizer.normalizeURI(this.unnormalizedSeqName);
        this.hasMetric = true;
        return this.seqName;
    }

    @Override
    protected void quit() {
        super.quit();
        if (this.httpStateObj != null) {
            try {
                Method m = this.httpStateObj.getClass().getMethod("getResponseCode", new Class[0]);
                this.httpCode = StringUtils.getAsInteger(m.invoke(this.httpStateObj, new Object[0]));
            }
            catch (Exception e) {
                JavaAgent.logger.debug("[IServer] Unable to fetch http code, Exception: " + e.getMessage());
            }
            this.httpStateObj = null;
        }
    }

    @Override
    public boolean generateMetric(SequenceHeader seqHeader, int childTrackersDuration, MetricData metricData) {
        ((ComponentMetric)metricData).recordComponentData(this.pointcutProperties.getComponent(), this.duration - childTrackersDuration, this.isErroneous());
        if (this.httpCode >= 400) {
            ((HTTPMetric)metricData).recordHttpRespCode(this.httpCode);
            ((ApdexMetric)metricData).recordErroneousData(this.getDuration());
        } else {
            ((ApdexMetric)metricData).recordData(this.getDuration(), seqHeader.getApplicationConfig().getWebSeqConfig().getApdexThreshold());
        }
        return true;
    }

    @Override
    public Map<String, Object> getContextualMetrics() {
        LinkedHashMap<String, Object> xtraMetrics = new LinkedHashMap<String, Object>(4, 1.0f);
        if (this.httpMethod != null) {
            xtraMetrics.put("http_method_name", this.httpMethod);
        }
        if (this.queryString != null) {
            xtraMetrics.put("http_query_str", this.queryString);
        }
        if (this.httpCode != 0) {
            xtraMetrics.put("httpcode", this.httpCode);
        }
        return xtraMetrics;
    }
}

