/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.http;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.config.WebSequenceConfig;
import com.manageengine.apminsight.agent.context.ContextInfoManager;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.trackers.WebSeqRootTracker;
import com.manageengine.apminsight.agent.util.SequenceURINormalizer;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class JerseyRequestTracker
extends WebSeqRootTracker {
    private Object requestObj;

    public JerseyRequestTracker(PointcutProperties pointcutProperties, Object thiz, Object[] args) {
        super(pointcutProperties, thiz, args);
        if (args != null && args.length > 0) {
            this.requestObj = args[0];
        }
        this.httpReq = null;
    }

    @Override
    protected String assignSequenceName() {
        if (this.requestObj == null) {
            this.seqName = "unknown";
            return this.seqName;
        }
        try {
            WebSequenceConfig webSeqConfig = ContextInfoManager.getInstance().getDefaultContextInfo().getConfig().getWebSeqConfig();
            Method method = this.requestObj.getClass().getMethod("getRequestUri", new Class[0]);
            method.setAccessible(true);
            URL url = new URL(method.invoke(this.requestObj, new Object[0]).toString());
            this.unnormalizedSeqName = url.getPath();
            this.seqName = SequenceURINormalizer.normalizeURI(this.unnormalizedSeqName);
            if (webSeqConfig.canSeqNamingUseRequestURL()) {
                String hostPart = url.getHost() + (url.getPort() != -1 ? ":" + url.getPort() : "") + "/";
                this.unnormalizedSeqName = hostPart + this.unnormalizedSeqName;
                this.seqName = hostPart + this.seqName;
            }
        }
        catch (Exception e) {
            JavaAgent.logger.warn("could not able to get requestURL. Exception: " + e.getMessage());
            this.seqName = "unknown";
        }
        try {
            Method method = this.requestObj.getClass().getMethod("getMethod", new Class[0]);
            method.setAccessible(true);
            this.httpMethod = method.invoke(this.requestObj, new Object[0]).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.requestObj = null;
        this.hasMetric = true;
        return this.seqName;
    }

    @Override
    public Map<String, Object> getContextualMetrics() {
        HashMap<String, Object> contextualMetrics = new HashMap<String, Object>();
        contextualMetrics.put("http_method_name", this.httpMethod);
        if (this.isErroneous()) {
            contextualMetrics.put("httpcode", 500);
        }
        return contextualMetrics;
    }
}

