/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.http;

import com.manageengine.apminsight.agent.trackers.http.ServerHttpResponse;
import java.lang.reflect.Method;

public class ServletHttpResponse
implements ServerHttpResponse {
    private Object response;
    private String responseClassName;

    public ServletHttpResponse(Object responseObj) {
        if (responseObj != null) {
            this.response = responseObj;
            this.responseClassName = responseObj.getClass().getName();
        }
    }

    @Override
    public int getResponseStatus() throws Exception {
        String methodName = this.responseClassName.startsWith("com.ibm") ? "getStatusCode" : "getStatus";
        return (Integer)this.response.getClass().getMethod(methodName, new Class[0]).invoke(this.response, new Object[0]);
    }

    @Override
    public long getBytesWritten() throws Exception {
        if (this.responseClassName.startsWith("org.apache.catalina")) {
            try {
                return (Long)this.response.getClass().getMethod("getContentWritten", new Class[0]).invoke(this.response, new Object[0]);
            }
            catch (NoSuchMethodException ex) {
                return (Long)this.response.getClass().getMethod("getContentCountLong", new Class[0]).invoke(this.response, new Object[0]);
            }
        }
        if (this.responseClassName.startsWith("weblogic")) {
            return ((Integer)this.response.getClass().getMethod("getContentLength", new Class[0]).invoke(this.response, new Object[0])).intValue();
        }
        return -1L;
    }

    @Override
    public void addHeader(String key, String value) throws Exception {
        Method m = this.response.getClass().getMethod("setHeader", String.class, String.class);
        m.invoke(this.response, key, value);
    }

    @Override
    public String getHeader(String key) throws Exception {
        Method m = this.response.getClass().getMethod("getHeader", String.class);
        return m.invoke(this.response, key).toString();
    }

    public boolean isCommitted() throws Exception {
        Method m = this.response.getClass().getDeclaredMethod("isCommitted", new Class[0]);
        m.setAccessible(true);
        return (Boolean)m.invoke(this.response, new Object[0]);
    }

    @Override
    public boolean containsHeader(String key) throws Exception {
        Method m = this.response.getClass().getDeclaredMethod("containsHeader", String.class);
        m.setAccessible(true);
        return (Boolean)m.invoke(this.response, key);
    }
}

