/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.httpclient;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.sequence.SequenceSpace;
import com.manageengine.apminsight.agent.trackers.httpclient.AbstractHttpClientTracker;
import com.manageengine.org.apache.logging.log4j.Level;
import java.lang.reflect.Method;

public class ApacheHttpClientReqTracker
extends AbstractHttpClientTracker {
    private Object respObj;

    public ApacheHttpClientReqTracker(PointcutProperties pointcutProperties, Object thiz, Object[] args) {
        block3: {
            super(pointcutProperties, thiz, args);
            try {
                this.httpUrl = this.getRequestUrl(args[0]);
                this.method = this.getHttpMethod(args[0]);
                this.setDTHeaderInRequest(args[0]);
                this.respObj = args[0];
                if (this.httpUrl != null && this.httpUrl.startsWith("http") || args.length <= 1 || args[1] == null) break block3;
                if (args[1].getClass().getSimpleName().equals("HostConfiguration")) {
                    Method m = args[1].getClass().getMethod("getHostURL", new Class[0]);
                    this.httpUrl = m.invoke(args[1], new Object[0]).toString() + (this.httpUrl != null ? (this.httpUrl.length() > 0 && this.httpUrl.charAt(0) == '/' ? this.httpUrl : "/" + this.httpUrl) : "/");
                    break block3;
                }
                this.httpUrl = args[1].toString() + (this.httpUrl != null ? (this.httpUrl.length() > 0 && this.httpUrl.charAt(0) == '/' ? this.httpUrl : "/" + this.httpUrl) : "/");
            }
            catch (Throwable th) {
                this.httpUrl = null;
                JavaAgent.logger.warn("[ApacheHttpClientTracker] Unable to construct the http url. Exception: " + th.getMessage());
            }
        }
    }

    @Override
    public void quit(int opcode, Object returnValue) {
        super.quit(opcode, returnValue);
        this.statusCode = this.getStatusCode(returnValue);
        this.respObj = this.pointcutProperties.getInterceptedClassName().startsWith("org/apache/commons") ? this.respObj : returnValue;
        this.dtData = this.getDTHeaderFromResponse(this.respObj);
        JavaAgent.logger.trace("[DistributedTracing] Incoming response, url " + this.httpUrl + " DT-DATA:" + this.dtData);
        this.respObj = null;
    }

    @Override
    public String getRequestUrl(Object requestObject) {
        try {
            Method getURI = requestObject.getClass().getMethod("getURI", new Class[0]);
            getURI.setAccessible(true);
            return getURI.invoke(requestObject, new Object[0]) + "";
        }
        catch (Throwable th) {
            JavaAgent.logger.log(Level.WARN, "ApacheHttpClientRequest Unable to get request URL. " + th.getMessage());
            return this.httpUrl;
        }
    }

    @Override
    public String getHttpMethod(Object requestObject) {
        try {
            Class<?> clz = requestObject.getClass();
            Method m = clz.getMethod(clz.getName().startsWith("org.apache.commons") ? "getName" : "getMethod", new Class[0]);
            m.setAccessible(true);
            return m.invoke(requestObject, new Object[0]).toString();
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("[ApacheHttpClient] Unable to get request type. " + th);
            return this.method;
        }
    }

    @Override
    public int getStatusCode(Object respObj) {
        if (respObj instanceof Integer) {
            return (Integer)respObj;
        }
        try {
            Method m = respObj.getClass().getMethod("getStatusLine", new Class[0]);
            Object statusline = m.invoke(respObj, new Object[0]);
            m = statusline.getClass().getMethod("getStatusCode", new Class[0]);
            return (Integer)m.invoke(statusline, new Object[0]);
        }
        catch (Throwable throwable) {
            return this.statusCode;
        }
    }

    @Override
    public void setDTHeaderInRequest(Object requestObject) {
        try {
            SequenceSpace seqSpace = SequenceSpace.SEQUENCE_BOOK.get();
            if (seqSpace.getConfig() != null && seqSpace.getConfig().isDistributedTracingEnabled()) {
                Class<?> reqClass;
                Method m = reqClass.getMethod((reqClass = requestObject.getClass()).getName().startsWith("org.apache.commons") ? "setRequestHeader" : "setHeader", String.class, String.class);
                m.invoke(requestObject, "X-Site24x7-Id", JavaAgent.getInstance().agentConfig.getDistributedTracingId());
                String id = "00-" + seqSpace.getRootTracker().getTraceID() + "-" + this.spanID + "-01";
                m.invoke(requestObject, "traceparent", id);
                JavaAgent.logger.trace("[DistributedTracing] Outgoing request id added to header " + this.httpUrl);
            }
        }
        catch (Exception e) {
            JavaAgent.logger.log(Level.WARN, "Unable to set DT header in request. Exception: " + e.getMessage());
        }
    }

    @Override
    public String getDTHeaderFromResponse(Object respObj) {
        try {
            Class<?> respClass = respObj.getClass();
            Method m = respClass.getMethod(respClass.getName().startsWith("org.apache.commons") ? "getResponseHeader" : "getFirstHeader", String.class);
            m.setAccessible(true);
            Object header = m.invoke(respObj, "X-Site24x7-DT-Data");
            if (header != null) {
                m = header.getClass().getMethod("getValue", new Class[0]);
                return (String)m.invoke(header, new Object[0]);
            }
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("[ApacheHttpClient] Exception while reading response header. " + th.getMessage());
        }
        return this.dtData;
    }
}

