/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.httpclient;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.config.JavaAgentConfig;
import com.manageengine.apminsight.agent.util.InetAddressUtil;
import com.manageengine.org.apache.logging.log4j.Level;
import com.manageengine.org.json.simple.JSONValue;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

public class HttpClientTrackerUtil {
    public static String obfuscateURL(String httpUrl) {
        int indexOfQueryString;
        if (httpUrl != null && (indexOfQueryString = httpUrl.indexOf(63)) != -1) {
            httpUrl = httpUrl.substring(0, indexOfQueryString);
        }
        return httpUrl;
    }

    public static String extractInstanceIdFromDtData(String dtData) {
        if (dtData != null) {
            try {
                Map data = (Map)JSONValue.parse(dtData);
                return (String)data.get("instance_id");
            }
            catch (Exception e) {
                JavaAgent.logger.warn("[HttpClientTrackerUtil] Unable to fetch instance id from DTdata={} Exception:{} ", dtData, e.getMessage());
            }
        }
        return null;
    }

    public static String extractServerAddress(String httpUrl) {
        String address = null;
        URL url = null;
        if (httpUrl != null && JavaAgentConfig.captureHostDetails) {
            try {
                try {
                    url = new URL(httpUrl);
                }
                catch (MalformedURLException e) {
                    httpUrl = "http://" + httpUrl;
                    url = new URL(httpUrl);
                }
                address = url.getHost() + ":" + (url.getPort() != -1 ? url.getPort() : url.getDefaultPort());
                address = InetAddressUtil.standardizeServerAddress(address);
            }
            catch (Throwable th) {
                JavaAgent.logger.log(Level.WARN, "[HttpClientTrackerUtil] Unable to extract server address from URL: " + httpUrl + " Exception: " + th.getMessage());
                address = null;
            }
        }
        return address;
    }
}

