/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.httpclient;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.HttpClientPointcutProperties;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.metrics.ComponentMetric;
import com.manageengine.apminsight.agent.metrics.MetricData;
import com.manageengine.apminsight.agent.sequence.SequenceHeader;
import com.manageengine.apminsight.agent.sequence.SequenceSpace;
import com.manageengine.apminsight.agent.trackers.httpclient.AbstractHttpClientTracker;
import com.manageengine.org.apache.logging.log4j.Level;
import java.net.HttpURLConnection;
import java.net.URLConnection;

public class HttpURLConnectionTracker
extends AbstractHttpClientTracker {
    private HttpURLConnection conn = null;
    private boolean isActualCall = false;

    public HttpURLConnectionTracker(PointcutProperties pointcut, Object thisObj, Object[] args) {
        super(pointcut, thisObj, args);
        try {
            this.conn = (HttpURLConnection)thisObj;
            this.httpUrl = this.getRequestUrl(thisObj);
            this.method = this.getHttpMethod(thisObj);
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("Unable to extract url connection metadata. Exception: " + th.getMessage());
        }
    }

    @Override
    public String getRequestUrl(Object requestObject) {
        return this.conn.getURL().toExternalForm();
    }

    @Override
    public String getHttpMethod(Object requestObject) {
        return this.conn.getRequestMethod();
    }

    @Override
    public void quit(int opcode, Object returnval) {
        super.quit(opcode, returnval);
    }

    @Override
    protected void quit() {
        super.quit();
        this.conn = null;
    }

    public void markAsActualCall() {
        this.isActualCall = true;
        this.pointcutProperties = new HttpClientPointcutProperties(this.pointcutProperties.getInterceptedClassName(), this.pointcutProperties.getInterceptedMethodName());
    }

    @Override
    public int getStatusCode(Object respObj) {
        return this.statusCode;
    }

    @Override
    public void setDTHeaderInRequest(Object requestObject) {
        try {
            SequenceSpace seqSpace = SequenceSpace.SEQUENCE_BOOK.get();
            if (seqSpace.currentTrackersCount() != 0 && seqSpace.getConfig().isDistributedTracingEnabled()) {
                this.conn.setRequestProperty("X-Site24x7-Id", JavaAgent.getInstance().agentConfig.getDistributedTracingId());
                String id = "00-" + seqSpace.getRootTracker().getTraceID() + "-" + this.spanID + "-01";
                this.conn.setRequestProperty("traceparent", id);
                JavaAgent.logger.trace("[DistributedTracing] Outgoing request id added to header " + this.httpUrl);
            }
        }
        catch (Throwable th) {
            JavaAgent.logger.log(Level.DEBUG, "[HttpUrlConnection] Error including distributed tracing id in request header. Exception: " + th.getMessage());
        }
    }

    @Override
    public String getDTHeaderFromResponse(Object respObj) {
        this.dtData = this.getHeader(this.conn, "X-Site24x7-DT-Data");
        JavaAgent.logger.trace("[DistributedTracing] Incoming response, url " + this.httpUrl + " DT-DATA:" + this.dtData);
        return this.dtData;
    }

    private String getHeader(URLConnection connectionObj, String headerName) {
        return connectionObj.getHeaderField(headerName);
    }

    @Override
    public boolean generateMetric(SequenceHeader seqHeader, int childDuration, MetricData metricData) {
        if (this.isActualCall) {
            return super.generateMetric(seqHeader, childDuration, metricData);
        }
        ((ComponentMetric)metricData).recordComponentData(this.pointcutProperties.getComponent(), this.duration - childDuration, this.isErroneous());
        return true;
    }

    @Override
    public String getTrackerSignature() {
        if (!this.isActualCall) {
            StringBuilder sb = new StringBuilder("HttpURLConnection");
            sb.append('.');
            sb.append(this.pointcutProperties.getInterceptedMethodName());
            if (this.statusCode > 0) {
                sb.append(" - ");
                sb.append(this.statusCode);
            }
            if (this.httpUrl != null) {
                sb.append(" - ");
                sb.append(this.httpUrl);
            }
            if (this.isErroneous()) {
                sb.append(" Error: " + this.error.getClass().getSimpleName());
            }
            return sb.toString();
        }
        return super.getTrackerSignature();
    }
}

