/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.httpclient;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.metrics.ComponentMetric;
import com.manageengine.apminsight.agent.metrics.MetricData;
import com.manageengine.apminsight.agent.sequence.SequenceHeader;
import com.manageengine.apminsight.agent.trackers.DefaultTracker;
import com.manageengine.apminsight.agent.trackers.httpclient.HttpClientTrackerUtil;
import java.lang.reflect.Method;

public class ReactorHttpClientTracker
extends DefaultTracker {
    private String url;
    private String method;

    public ReactorHttpClientTracker(PointcutProperties interceptPointMetaData, Object thiz, Object[] args) {
        super(interceptPointMetaData, thiz, args);
        this.isLeafTracker = true;
        this.extractInfo(thiz);
    }

    private void extractInfo(Object thiz) {
        try {
            Method method = thiz.getClass().getMethod("configuration", new Class[0]);
            method.setAccessible(true);
            Object config = method.invoke(thiz, new Object[0]);
            method = config.getClass().getMethod("uri", new Class[0]);
            method.setAccessible(true);
            this.url = method.invoke(config, new Object[0]).toString();
            method = config.getClass().getMethod("method", new Class[0]);
            method.setAccessible(true);
            this.method = method.invoke(config, new Object[0]).toString();
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("[ReactorHttpClient] Unable to extract client details. Exception: " + th.getMessage());
        }
    }

    @Override
    public boolean generateMetric(SequenceHeader seqHeader, int childDuration, MetricData metricData) {
        ((ComponentMetric)metricData).recordComponentData(this.pointcutProperties.getComponent(), HttpClientTrackerUtil.extractServerAddress(this.url), this.duration - childDuration, this.isErroneous());
        return true;
    }

    @Override
    public String getTrackerSignature() {
        if (this.url == null) {
            return super.getTrackerSignature();
        }
        StringBuffer signature = new StringBuffer();
        if (this.method != null) {
            signature.append(this.method.toUpperCase());
            signature.append(" - ");
        }
        signature.append(this.url);
        if (this.isErroneous()) {
            signature.append(" Error: " + this.error.getClass().getSimpleName());
        }
        return signature.toString();
    }
}

