/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.httpclient.async;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.metrics.ComponentMetric;
import com.manageengine.apminsight.agent.metrics.MetricData;
import com.manageengine.apminsight.agent.sequence.SequenceHeader;
import com.manageengine.apminsight.agent.trackers.CallerAsyncRootTracker;
import com.manageengine.apminsight.agent.trackers.httpclient.HttpClientTrackerUtil;
import com.manageengine.apminsight.agent.trackers.httpclient.IHttpClientTracker;
import com.manageengine.apminsight.agent.util.SequenceURINormalizer;
import com.manageengine.org.apache.logging.log4j.Level;
import com.manageengine.org.json.simple.JSONValue;
import java.net.URL;
import java.util.Map;

public abstract class AbstractAsyncHttpClientTracker
extends CallerAsyncRootTracker
implements IHttpClientTracker {
    protected String method;
    protected String httpUrl;
    protected String dtData;
    protected String serverAddress;
    protected int statusCode = 0;

    public AbstractAsyncHttpClientTracker(PointcutProperties pointcutProperties, Object thiz, Object[] args) {
        super(pointcutProperties, thiz, args);
        this.isLeafTracker = true;
    }

    @Override
    protected String assignSequenceName() {
        if (this.httpUrl == null) {
            this.seqName = super.assignSequenceName();
        } else {
            try {
                URL url = new URL(this.httpUrl);
                this.unnormalizedSeqName = url.getProtocol() + "://" + url.getAuthority() + "/" + url.getPath();
                this.seqName = url.getProtocol() + "://" + url.getAuthority() + "/" + SequenceURINormalizer.normalizeURI(url.getPath());
            }
            catch (Exception e) {
                this.seqName = this.httpUrl;
                JavaAgent.logger.log(Level.WARN, "[AbstractAsyncHttpClientTracker] Unable to normalize url, retaining the original. Exception: " + e.getMessage());
            }
        }
        this.hasMetric = true;
        return this.seqName;
    }

    @Override
    public void markCompleted(Object returnObj) {
        super.markCompleted(returnObj);
        this.statusCode = this.getStatusCode(returnObj);
        this.dtData = this.getDTHeaderFromResponse(returnObj);
        JavaAgent.logger.debug("[DistributedTracing] Incoming response, url " + this.httpUrl + " DT-DATA:" + this.dtData);
    }

    @Override
    protected void quit() {
        super.quit();
        if (this.httpUrl != null) {
            this.httpUrl = HttpClientTrackerUtil.obfuscateURL(this.httpUrl);
        }
    }

    @Override
    public boolean generateMetric(SequenceHeader seqHeader, int childDuration, MetricData metricData) {
        super.generateMetric(seqHeader, childDuration, metricData);
        ((ComponentMetric)metricData).recordComponentData(this.pointcutProperties.getComponent(), this.getServerAddress(), HttpClientTrackerUtil.extractInstanceIdFromDtData(this.dtData), this.duration - childDuration, this.isErroneous());
        return true;
    }

    @Override
    public Map<String, Object> getMoreData(Map<String, Object> moreData) {
        if (this.dtData != null) {
            Map data = (Map)JSONValue.parse(this.dtData);
            moreData.put("dtdata", data);
        }
        return moreData;
    }

    @Override
    public boolean isDTCall() {
        return this.dtData != null;
    }

    @Override
    public Map<String, String> getDTdata() {
        if (this.dtData == null) {
            return null;
        }
        return (Map)JSONValue.parse(this.dtData);
    }

    @Override
    public String getServerAddress() {
        if (this.serverAddress == null) {
            this.serverAddress = HttpClientTrackerUtil.extractServerAddress(this.httpUrl);
        }
        return this.serverAddress;
    }

    @Override
    public String getTrackerSignature() {
        if (this.httpUrl == null) {
            return super.getTrackerSignature();
        }
        StringBuffer signature = new StringBuffer(this.getTrackerSignaturePrefix());
        if (this.method != null) {
            signature.append(this.method.toUpperCase());
            signature.append(" - ");
        }
        if (this.statusCode > 0) {
            signature.append(this.statusCode);
            signature.append(" - ");
        }
        signature.append(this.httpUrl);
        if (this.isErroneous()) {
            signature.append(" Error: " + this.error.getClass().getSimpleName());
        }
        return signature.toString();
    }

    @Override
    public String getNormalizedSignature() {
        if (this.httpUrl == null) {
            return super.getTrackerSignature();
        }
        StringBuffer signature = new StringBuffer(this.getTrackerSignaturePrefix());
        if (this.method != null) {
            signature.append(this.method.toUpperCase());
            signature.append(" - ");
        }
        signature.append(this.httpUrl);
        return signature.toString();
    }
}

